/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Type;
import java.util.Optional;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.type.JaversType;

abstract class ClassType
extends JaversType {
    private final Class baseJavaClass;

    ClassType(Type baseJavaType) {
        this(baseJavaType, Optional.empty());
    }

    ClassType(Type baseJavaType, Optional<String> name) {
        this(baseJavaType, name, 0);
    }

    ClassType(Type baseJavaType, Optional<String> name, int expectedArgs) {
        super(baseJavaType, name, expectedArgs);
        Validate.argumentIsNotNull(name);
        this.baseJavaClass = ReflectionUtil.extractClass(baseJavaType);
    }

    @Override
    public boolean canBePrototype() {
        return true;
    }

    @Override
    public boolean isInstance(Object cdo) {
        Validate.argumentIsNotNull(cdo);
        return this.baseJavaClass.isAssignableFrom(cdo.getClass());
    }

    protected Type getRawDehydratedType() {
        return this.baseJavaClass;
    }

    public Class getBaseJavaClass() {
        return this.baseJavaClass;
    }
}

