/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.appenders;

import java.util.List;
import java.util.Map;
import org.javers.common.collections.Arrays;
import org.javers.common.collections.Lists;
import org.javers.core.diff.NodePair;
import org.javers.core.diff.appenders.MapChangeAppender;
import org.javers.core.diff.appenders.MapChangesToListChangesFunction;
import org.javers.core.diff.appenders.PropertyChangeAppender;
import org.javers.core.diff.changetype.container.ArrayChange;
import org.javers.core.diff.changetype.container.ContainerElementChange;
import org.javers.core.diff.changetype.map.EntryChange;
import org.javers.core.metamodel.type.ArrayType;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.JaversType;

class ArrayChangeAppender
implements PropertyChangeAppender<ArrayChange> {
    private final MapChangeAppender mapChangeAppender;

    ArrayChangeAppender(MapChangeAppender mapChangeAppender) {
        this.mapChangeAppender = mapChangeAppender;
    }

    @Override
    public boolean supports(JaversType propertyType) {
        return propertyType instanceof ArrayType;
    }

    @Override
    public ArrayChange calculateChanges(NodePair pair, JaversProperty property) {
        ArrayType arrayType;
        Map rightMap;
        Map leftMap = Arrays.asMap(pair.getLeftDehydratedPropertyValueAndSanitize(property));
        List<EntryChange> entryChanges = this.mapChangeAppender.calculateEntryChanges(leftMap, rightMap = Arrays.asMap(pair.getRightDehydratedPropertyValueAndSanitize(property)), (arrayType = (ArrayType)property.getType()).getItemJaversType());
        if (!entryChanges.isEmpty()) {
            List<ContainerElementChange> elementChanges = Lists.transform(entryChanges, new MapChangesToListChangesFunction());
            return new ArrayChange(pair.createPropertyChangeMetadata(property), elementChanges, pair.getLeftPropertyValueAndSanitize(property), pair.getRightPropertyValueAndSanitize(property));
        }
        return null;
    }
}

