/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.javers.common.validation.Validate;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.diff.NodePair;
import org.javers.core.graph.ObjectNode;
import org.javers.core.metamodel.object.GlobalId;

class NodeMatcher {
    NodeMatcher() {
    }

    static List<NodePair> match(Set<ObjectNode> leftNodes, Set<ObjectNode> rightNodes, Optional<CommitMetadata> commitMetadata) {
        Validate.argumentsAreNotNull(leftNodes, rightNodes, commitMetadata);
        ArrayList<NodePair> pairs = new ArrayList<NodePair>();
        Map<GlobalId, ObjectNode> rightMap = NodeMatcher.asMap(rightNodes);
        for (ObjectNode left : leftNodes) {
            GlobalId key = left.getGlobalId();
            if (!rightMap.containsKey(key)) continue;
            pairs.add(new NodePair(left, rightMap.get(key), commitMetadata));
        }
        return pairs;
    }

    private static Map<GlobalId, ObjectNode> asMap(Set<ObjectNode> nodes) {
        HashMap<GlobalId, ObjectNode> map = new HashMap<GlobalId, ObjectNode>();
        for (ObjectNode node : nodes) {
            map.put(node.getGlobalId(), node);
        }
        return map;
    }
}

