/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.validation.Validate;
import org.javers.core.CoreConfiguration;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.diff.Change;
import org.javers.core.diff.Diff;
import org.javers.core.diff.DiffBuilder;
import org.javers.core.diff.EmptyGraph;
import org.javers.core.diff.GraphPair;
import org.javers.core.diff.NodeMatcher;
import org.javers.core.diff.NodePair;
import org.javers.core.diff.appenders.NodeChangeAppender;
import org.javers.core.diff.appenders.PropertyChangeAppender;
import org.javers.core.diff.changetype.ObjectRemoved;
import org.javers.core.graph.Cdo;
import org.javers.core.graph.FakeNode;
import org.javers.core.graph.LiveGraphFactory;
import org.javers.core.graph.ObjectGraph;
import org.javers.core.graph.ObjectNode;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.PrimitiveType;
import org.javers.core.metamodel.type.TypeMapper;
import org.javers.core.metamodel.type.ValueType;

public class DiffFactory {
    private final NodeMatcher nodeMatcher = new NodeMatcher();
    private final TypeMapper typeMapper;
    private final List<NodeChangeAppender> nodeChangeAppenders;
    private final List<PropertyChangeAppender> propertyChangeAppender;
    private final LiveGraphFactory graphFactory;
    private final CoreConfiguration javersCoreConfiguration;

    public DiffFactory(TypeMapper typeMapper, List<NodeChangeAppender> nodeChangeAppenders, List<PropertyChangeAppender> propertyChangeAppender, LiveGraphFactory graphFactory, CoreConfiguration javersCoreConfiguration) {
        this.typeMapper = typeMapper;
        this.nodeChangeAppenders = nodeChangeAppenders;
        this.graphFactory = graphFactory;
        this.javersCoreConfiguration = javersCoreConfiguration;
        Collections.sort(propertyChangeAppender, (p1, p2) -> Integer.valueOf(p1.priority()).compareTo(p2.priority()));
        this.propertyChangeAppender = propertyChangeAppender;
    }

    public Diff compare(Object oldVersion, Object currentVersion) {
        return this.create(this.buildGraph(oldVersion), this.buildGraph(currentVersion), Optional.empty());
    }

    public <T> Diff compareCollections(Collection<T> oldVersion, Collection<T> currentVersion, Class<T> itemClass) {
        return this.create(this.buildGraph(oldVersion, itemClass), this.buildGraph(currentVersion, itemClass), Optional.empty());
    }

    private ObjectGraph buildGraph(Collection handle, Class itemClass) {
        return this.graphFactory.createLiveGraph(handle, itemClass);
    }

    public Diff create(ObjectGraph leftGraph, ObjectGraph rightGraph, Optional<CommitMetadata> commitMetadata) {
        Validate.argumentsAreNotNull(leftGraph, rightGraph);
        GraphPair graphPair = new GraphPair(leftGraph, rightGraph, commitMetadata);
        return this.createAndAppendChanges(graphPair);
    }

    public Diff singleTerminal(GlobalId removedId, CommitMetadata commitMetadata) {
        Validate.argumentsAreNotNull(removedId, commitMetadata);
        DiffBuilder diff = new DiffBuilder(this.javersCoreConfiguration.getPrettyValuePrinter());
        diff.addChange(new ObjectRemoved(removedId, Optional.empty(), Optional.of(commitMetadata)));
        return diff.build();
    }

    public Diff initial(Object newDomainObject) {
        ObjectGraph currentGraph = this.buildGraph(newDomainObject);
        GraphPair graphPair = new GraphPair(currentGraph);
        return this.createAndAppendChanges(graphPair);
    }

    private ObjectGraph buildGraph(Object handle) {
        if (handle == null) {
            return new EmptyGraph();
        }
        JaversType jType = this.typeMapper.getJaversType(handle.getClass());
        if (jType instanceof ValueType || jType instanceof PrimitiveType) {
            throw new JaversException(JaversExceptionCode.COMPARING_TOP_LEVEL_VALUES_NOT_SUPPORTED, jType.getClass().getSimpleName(), handle.getClass().getSimpleName());
        }
        return this.graphFactory.createLiveGraph(handle);
    }

    private Diff createAndAppendChanges(GraphPair graphPair) {
        NodePair pair;
        DiffBuilder diff = new DiffBuilder(this.javersCoreConfiguration.getPrettyValuePrinter());
        for (NodeChangeAppender appender : this.nodeChangeAppenders) {
            diff.addChanges(appender.getChangeSet(graphPair));
        }
        if (this.javersCoreConfiguration.isInitialChanges()) {
            for (ObjectNode node : graphPair.getOnlyOnRight()) {
                pair = new NodePair(new FakeNode((Cdo)node.getCdo(), this.javersCoreConfiguration.getUsePrimitiveDefaults()), node, graphPair.getCommitMetadata());
                this.appendPropertyChanges(diff, pair);
            }
        }
        if (this.javersCoreConfiguration.isTerminalChanges()) {
            for (ObjectNode node : graphPair.getOnlyOnLeft()) {
                pair = new NodePair(node, new FakeNode((Cdo)node.getCdo(), this.javersCoreConfiguration.getUsePrimitiveDefaults()), graphPair.getCommitMetadata());
                this.appendPropertyChanges(diff, pair);
            }
        }
        for (NodePair pair2 : graphPair.getMatching()) {
            this.appendPropertyChanges(diff, pair2);
        }
        return diff.build();
    }

    private void appendPropertyChanges(DiffBuilder diff, NodePair pair) {
        List<JaversProperty> nodeProperties = pair.getProperties();
        for (JaversProperty property : nodeProperties) {
            if (pair.isNullOnBothSides(property)) continue;
            Object javersType = property.getType();
            this.appendChanges(diff, pair, property, (JaversType)javersType);
        }
    }

    private void appendChanges(DiffBuilder diff, NodePair pair, JaversProperty property, JaversType javersType) {
        for (PropertyChangeAppender appender : this.propertyChangeAppender) {
            if (!appender.supports(javersType)) continue;
            Object change = appender.calculateChanges(pair, property);
            if (change == null) break;
            diff.addChange((Change)change, pair.getRight().wrappedCdo());
            break;
        }
    }
}

