/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core;

import com.google.gson.TypeAdapter;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.javers.common.date.DateProvider;
import org.javers.common.date.DefaultDateProvider;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.common.validation.Validate;
import org.javers.core.AbstractContainerBuilder;
import org.javers.core.CommitIdGenerator;
import org.javers.core.ConditionalTypesPlugin;
import org.javers.core.CoreConfiguration;
import org.javers.core.CoreConfigurationBuilder;
import org.javers.core.CoreJaversModule;
import org.javers.core.IgnoredClassesStrategy;
import org.javers.core.Javers;
import org.javers.core.JaversCore;
import org.javers.core.JaversCoreProperties;
import org.javers.core.MappingStyle;
import org.javers.core.commit.CommitFactoryModule;
import org.javers.core.commit.CommitId;
import org.javers.core.diff.Diff;
import org.javers.core.diff.DiffFactoryModule;
import org.javers.core.diff.ListCompareAlgorithm;
import org.javers.core.diff.appenders.DiffAppendersModule;
import org.javers.core.diff.custom.CustomPropertyComparator;
import org.javers.core.diff.custom.CustomToNativeAppenderAdapter;
import org.javers.core.diff.custom.CustomValueComparator;
import org.javers.core.graph.GraphFactoryModule;
import org.javers.core.graph.ObjectAccessHook;
import org.javers.core.graph.ObjectHasher;
import org.javers.core.graph.SnapshotObjectHasher;
import org.javers.core.graph.TailoredJaversMemberFactoryModule;
import org.javers.core.json.JsonAdvancedTypeAdapter;
import org.javers.core.json.JsonConverter;
import org.javers.core.json.JsonConverterBuilder;
import org.javers.core.json.JsonTypeAdapter;
import org.javers.core.json.typeadapter.change.ChangeTypeAdaptersModule;
import org.javers.core.json.typeadapter.commit.CommitTypeAdaptersModule;
import org.javers.core.json.typeadapter.commit.DiffTypeDeserializer;
import org.javers.core.metamodel.annotation.TypeName;
import org.javers.core.metamodel.clazz.ClientsClassDefinition;
import org.javers.core.metamodel.clazz.CustomDefinition;
import org.javers.core.metamodel.clazz.EntityDefinition;
import org.javers.core.metamodel.clazz.IgnoredTypeDefinition;
import org.javers.core.metamodel.clazz.ValueDefinition;
import org.javers.core.metamodel.clazz.ValueObjectDefinition;
import org.javers.core.metamodel.scanner.ScannerModule;
import org.javers.core.metamodel.type.DynamicMappingStrategy;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.TypeMapper;
import org.javers.core.metamodel.type.TypeMapperLazy;
import org.javers.core.metamodel.type.TypeMapperModule;
import org.javers.core.pico.AddOnsModule;
import org.javers.core.snapshot.SnapshotModule;
import org.javers.groovysupport.GroovyAddOns;
import org.javers.guava.GuavaAddOns;
import org.javers.mongosupport.MongoLong64JsonDeserializer;
import org.javers.mongosupport.RequiredMongoSupportPredicate;
import org.javers.repository.api.ConfigurationAware;
import org.javers.repository.api.JaversExtendedRepository;
import org.javers.repository.api.JaversRepository;
import org.javers.repository.inmemory.InMemoryRepository;
import org.javers.repository.jql.JqlModule;
import org.javers.shadow.ShadowModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaversBuilder
extends AbstractContainerBuilder {
    public static final Logger logger = LoggerFactory.getLogger(JaversBuilder.class);
    private final Map<Class, ClientsClassDefinition> clientsClassDefinitions = new LinkedHashMap<Class, ClientsClassDefinition>();
    private final Map<Class, Function<Object, String>> mappedToStringFunction = new ConcurrentHashMap<Class, Function<Object, String>>();
    private final Set<Class> classesToScan = new HashSet<Class>();
    private final Set<ConditionalTypesPlugin> conditionalTypesPlugins;
    private CoreConfigurationBuilder coreConfigurationBuilder = CoreConfigurationBuilder.coreConfiguration();
    private JaversRepository repository;
    private DateProvider dateProvider;
    private long bootStart = System.currentTimeMillis();
    private Class<? extends ObjectHasher> objectHasherImplementation = SnapshotObjectHasher.class;
    private IgnoredClassesStrategy ignoredClassesStrategy;

    public static JaversBuilder javers() {
        return new JaversBuilder();
    }

    protected JaversBuilder() {
        logger.debug("starting up JaVers ...");
        this.conditionalTypesPlugins = new HashSet<ConditionalTypesPlugin>();
        if (ReflectionUtil.isClassPresent("groovy.lang.MetaClass")) {
            this.conditionalTypesPlugins.add(new GroovyAddOns());
        }
        if (ReflectionUtil.isClassPresent("com.google.common.collect.Multimap")) {
            this.conditionalTypesPlugins.add(new GuavaAddOns());
        }
        this.bootContainer();
        this.addModule(new CoreJaversModule(this.getContainer()));
    }

    public Javers build() {
        Javers javers = this.assembleJaversInstanceAndEnsureSchema();
        long boot = System.currentTimeMillis() - this.bootStart;
        logger.info("JaVers instance started in {} ms", (Object)boot);
        return javers;
    }

    protected Javers assembleJaversInstanceAndEnsureSchema() {
        Javers javers = this.assembleJaversInstance();
        this.repository.ensureSchema();
        return javers;
    }

    protected Javers assembleJaversInstance() {
        CoreConfiguration coreConfiguration = this.configurationBuilder().build();
        this.addComponent(coreConfiguration);
        this.addModule(new DiffFactoryModule());
        this.addModule(new CommitFactoryModule(this.getContainer()));
        this.addModule(new SnapshotModule(this.getContainer()));
        this.addModule(new GraphFactoryModule(this.getContainer(), this.objectHasherImplementation));
        this.addModule(new DiffAppendersModule(coreConfiguration, this.getContainer()));
        this.addModule(new TailoredJaversMemberFactoryModule(coreConfiguration, this.getContainer()));
        this.addModule(new ScannerModule(coreConfiguration, this.getContainer()));
        this.addModule(new ShadowModule(this.getContainer()));
        this.addModule(new JqlModule(this.getContainer()));
        this.addComponent(new DynamicMappingStrategy(this.ignoredClassesStrategy));
        this.addModule(new TypeMapperModule(this.getContainer()));
        Set<JaversType> additionalTypes = this.bootAddOns();
        this.bootJsonConverter();
        this.bootDateTimeProvider();
        this.classesToScan.forEach(c -> this.typeMapper().getJaversType((Type)c));
        this.typeMapper().addPluginTypes(additionalTypes);
        this.typeMapper().registerCoreTypes(coreConfiguration, this.clientsClassDefinitions.values());
        this.mapRegisteredClasses();
        this.bootRepository();
        return this.getContainerComponent(JaversCore.class);
    }

    public JaversBuilder registerObjectHasher(Class<? extends ObjectHasher> objectHasherType) {
        this.objectHasherImplementation = objectHasherType;
        return this;
    }

    public JaversBuilder registerJaversRepository(JaversRepository repository) {
        Validate.argumentsAreNotNull(repository);
        this.repository = repository;
        return this;
    }

    public JaversBuilder registerEntity(Class<?> entityClass) {
        Validate.argumentIsNotNull(entityClass);
        return this.registerEntity(new EntityDefinition(entityClass));
    }

    public JaversBuilder registerValueObject(Class<?> valueObjectClass) {
        Validate.argumentIsNotNull(valueObjectClass);
        this.registerType(new ValueObjectDefinition(valueObjectClass));
        return this;
    }

    public JaversBuilder registerEntity(EntityDefinition entityDefinition) {
        Validate.argumentIsNotNull(entityDefinition);
        return this.registerType(entityDefinition);
    }

    public JaversBuilder registerType(ClientsClassDefinition clientsClassDefinition) {
        Validate.argumentIsNotNull(clientsClassDefinition);
        this.clientsClassDefinitions.compute(clientsClassDefinition.getBaseJavaClass(), (baseJavaClass, oldClientsClassDefinition) -> {
            if (oldClientsClassDefinition != null) {
                throw new JaversException(JaversExceptionCode.ATTEMPT_TO_OVERWRITE_EXISTING_CLIENT_CLASS_DEFINITION, baseJavaClass.getName());
            }
            return clientsClassDefinition;
        });
        return this;
    }

    public JaversBuilder registerTypes(Collection<ClientsClassDefinition> clientsClassDefinitions) {
        Validate.argumentIsNotNull(clientsClassDefinitions);
        clientsClassDefinitions.forEach(it -> this.registerType((ClientsClassDefinition)it));
        return this;
    }

    public JaversBuilder registerValueObject(ValueObjectDefinition valueObjectDefinition) {
        Validate.argumentIsNotNull(valueObjectDefinition);
        this.registerType(valueObjectDefinition);
        return this;
    }

    public JaversBuilder withPackagesToScan(String packagesToScan) {
        if (packagesToScan == null || packagesToScan.trim().isEmpty()) {
            return this;
        }
        long start = System.currentTimeMillis();
        logger.info("scanning package(s): {}", (Object)packagesToScan);
        List<Class<?>> scan = ReflectionUtil.findClasses(TypeName.class, packagesToScan.replaceAll(" ", "").split(","));
        for (Class<?> c : scan) {
            this.scanTypeName(c);
        }
        long delta = System.currentTimeMillis() - start;
        logger.info("  found {} ManagedClass(es) with @TypeName in {} ms", (Object)scan.size(), (Object)delta);
        return this;
    }

    public JaversBuilder scanTypeName(Class userType) {
        this.classesToScan.add(userType);
        return this;
    }

    public JaversBuilder registerValue(Class<?> valueClass) {
        Validate.argumentIsNotNull(valueClass);
        this.registerType(new ValueDefinition(valueClass));
        return this;
    }

    public <T> JaversBuilder registerValue(Class<T> valueClass, CustomValueComparator<T> customValueComparator) {
        Validate.argumentsAreNotNull(valueClass, customValueComparator);
        this.registerType(new ValueDefinition(valueClass, customValueComparator));
        return this;
    }

    public <T> JaversBuilder registerValue(Class<T> valueClass, final BiFunction<T, T, Boolean> equalsFunction, final Function<T, String> toStringFunction) {
        Validate.argumentsAreNotNull(valueClass, equalsFunction, toStringFunction);
        return this.registerValue(valueClass, new CustomValueComparator<T>(){

            @Override
            public boolean equals(T a, T b) {
                return (Boolean)equalsFunction.apply(a, b);
            }

            @Override
            public String toString(@Nonnull T value) {
                return (String)toStringFunction.apply(value);
            }
        });
    }

    @Deprecated
    public <T> JaversBuilder registerValue(Class<T> valueClass, final BiFunction<T, T, Boolean> equalsFunction) {
        Validate.argumentsAreNotNull(valueClass, equalsFunction);
        return this.registerValue(valueClass, new CustomValueComparator<T>(){

            @Override
            public boolean equals(T a, T b) {
                return (Boolean)equalsFunction.apply(a, b);
            }

            @Override
            public String toString(@Nonnull T value) {
                return value.toString();
            }
        });
    }

    @Deprecated
    public <T> JaversBuilder registerValueWithCustomToString(Class<T> valueClass, Function<T, String> toStringFunction) {
        Validate.argumentsAreNotNull(valueClass, toStringFunction);
        return this.registerValue(valueClass, (a, b) -> Objects.equals(a, b), toStringFunction);
    }

    public JaversBuilder registerIgnoredClass(Class<?> ignoredClass) {
        Validate.argumentIsNotNull(ignoredClass);
        this.registerType(new IgnoredTypeDefinition(ignoredClass));
        return this;
    }

    public JaversBuilder registerIgnoredClassesStrategy(IgnoredClassesStrategy ignoredClassesStrategy) {
        Validate.argumentIsNotNull(ignoredClassesStrategy);
        this.ignoredClassesStrategy = ignoredClassesStrategy;
        return this;
    }

    public JaversBuilder registerValueTypeAdapter(JsonTypeAdapter typeAdapter) {
        for (Class c : typeAdapter.getValueTypes()) {
            if (this.clientsClassDefinitions.containsKey(c)) continue;
            this.registerValue(c);
        }
        this.jsonConverterBuilder().registerJsonTypeAdapter(typeAdapter);
        return this;
    }

    public JaversBuilder registerJsonAdvancedTypeAdapter(JsonAdvancedTypeAdapter adapter) {
        this.jsonConverterBuilder().registerJsonAdvancedTypeAdapter(adapter);
        return this;
    }

    public JaversBuilder registerValueGsonTypeAdapter(Class valueType, TypeAdapter nativeAdapter) {
        if (!this.clientsClassDefinitions.containsKey(valueType)) {
            this.registerValue(valueType);
        }
        this.jsonConverterBuilder().registerNativeTypeAdapter(valueType, nativeAdapter);
        return this;
    }

    public JaversBuilder withTypeSafeValues(boolean typeSafeValues) {
        this.jsonConverterBuilder().typeSafeValues(typeSafeValues);
        return this;
    }

    public JaversBuilder withPrettyPrint(boolean prettyPrint) {
        this.coreConfigurationBuilder.withPrettyPrint(prettyPrint);
        return this;
    }

    public JaversBuilder registerEntities(Class<?> ... entityClasses) {
        for (Class<?> clazz : entityClasses) {
            this.registerEntity(clazz);
        }
        return this;
    }

    public JaversBuilder registerValueObjects(Class<?> ... valueObjectClasses) {
        for (Class<?> clazz : valueObjectClasses) {
            this.registerValueObject(clazz);
        }
        return this;
    }

    public JaversBuilder withMappingStyle(MappingStyle mappingStyle) {
        Validate.argumentIsNotNull((Object)mappingStyle);
        this.configurationBuilder().withMappingStyle(mappingStyle);
        return this;
    }

    public JaversBuilder withCommitIdGenerator(CommitIdGenerator commitIdGenerator) {
        this.configurationBuilder().withCommitIdGenerator(commitIdGenerator);
        return this;
    }

    public JaversBuilder withCustomCommitIdGenerator(Supplier<CommitId> commitIdGenerator) {
        this.configurationBuilder().withCustomCommitIdGenerator(commitIdGenerator);
        return this;
    }

    public JaversBuilder withInitialChanges(boolean initialChanges) {
        this.configurationBuilder().withInitialChanges(initialChanges);
        return this;
    }

    public JaversBuilder withUsePrimitiveDefaults(boolean usePrimitiveDefaults) {
        this.configurationBuilder().withUsePrimitiveDefaults(usePrimitiveDefaults);
        return this;
    }

    @Deprecated
    public JaversBuilder withNewObjectsSnapshot(boolean newObjectsSnapshot) {
        return this.withInitialChanges(newObjectsSnapshot);
    }

    public JaversBuilder withTerminalChanges(boolean terminalChanges) {
        this.configurationBuilder().withTerminalChanges(terminalChanges);
        return this;
    }

    public JaversBuilder withObjectAccessHook(ObjectAccessHook objectAccessHook) {
        this.removeComponent(ObjectAccessHook.class);
        this.bindComponent(ObjectAccessHook.class, objectAccessHook);
        return this;
    }

    public <T> JaversBuilder registerCustomType(Class<T> customType, CustomPropertyComparator<T, ?> comparator) {
        this.registerType(new CustomDefinition<T>(customType, comparator));
        this.bindComponent(comparator, new CustomToNativeAppenderAdapter(comparator, customType));
        return this;
    }

    @Deprecated
    public <T> JaversBuilder registerCustomComparator(CustomPropertyComparator<T, ?> comparator, Class<T> customType) {
        return this.registerCustomType(customType, comparator);
    }

    public JaversBuilder withListCompareAlgorithm(ListCompareAlgorithm algorithm) {
        Validate.argumentIsNotNull((Object)algorithm);
        this.configurationBuilder().withListCompareAlgorithm(algorithm);
        return this;
    }

    public JaversBuilder withDateTimeProvider(DateProvider dateProvider) {
        Validate.argumentIsNotNull(dateProvider);
        this.dateProvider = dateProvider;
        return this;
    }

    public JaversBuilder withPrettyPrintDateFormats(JaversCoreProperties.PrettyPrintDateFormats prettyPrintDateFormats) {
        this.configurationBuilder().withPrettyPrintDateFormats(prettyPrintDateFormats);
        return this;
    }

    public JaversBuilder withProperties(JaversCoreProperties javersProperties) {
        if (javersProperties.getMappingStyle() != null) {
            this.withMappingStyle(MappingStyle.valueOf(javersProperties.getMappingStyle().toUpperCase()));
        }
        if (javersProperties.getCommitIdGenerator() != null) {
            this.withCommitIdGenerator(CommitIdGenerator.valueOf(javersProperties.getCommitIdGenerator().toUpperCase()));
        }
        if (javersProperties.getPackagesToScan() != null) {
            this.withPackagesToScan(javersProperties.getPackagesToScan());
        }
        if (javersProperties.isTypeSafeValues() != null) {
            this.withTypeSafeValues(javersProperties.isTypeSafeValues());
        }
        if (javersProperties.getAlgorithm() != null) {
            this.withListCompareAlgorithm(ListCompareAlgorithm.valueOf(javersProperties.getAlgorithm().toUpperCase()));
        }
        if (javersProperties.isPrettyPrint() != null) {
            this.withPrettyPrint(javersProperties.isPrettyPrint());
        }
        if (javersProperties.isInitialChanges() != null) {
            this.withInitialChanges(javersProperties.isInitialChanges());
        }
        if (javersProperties.isTerminalChanges() != null) {
            this.withTerminalChanges(javersProperties.isTerminalChanges());
        }
        if (javersProperties.isUsePrimitiveDefaults() != null) {
            this.withUsePrimitiveDefaults(javersProperties.isUsePrimitiveDefaults());
        }
        this.withPrettyPrintDateFormats(javersProperties.getPrettyPrintDateFormats());
        return this;
    }

    private void mapRegisteredClasses() {
        TypeMapper typeMapper = this.typeMapper();
        this.clientsClassDefinitions.values().forEach(def -> typeMapper.registerClientsClass((ClientsClassDefinition)def));
    }

    private TypeMapper typeMapper() {
        return this.getContainerComponent(TypeMapper.class);
    }

    private TypeMapperLazy typeMapperLazy() {
        return this.typeMapper();
    }

    private CoreConfigurationBuilder configurationBuilder() {
        return this.coreConfigurationBuilder;
    }

    private JsonConverterBuilder jsonConverterBuilder() {
        return this.getContainerComponent(JsonConverterBuilder.class);
    }

    private Set<JaversType> bootAddOns() {
        HashSet<JaversType> additionalTypes = new HashSet<JaversType>();
        for (ConditionalTypesPlugin plugin : this.conditionalTypesPlugins) {
            logger.info("loading " + plugin.getClass().getSimpleName() + " ...");
            plugin.beforeAssemble(this);
            additionalTypes.addAll(plugin.getNewTypes(this.typeMapperLazy()));
            AddOnsModule addOnsModule = new AddOnsModule(this.getContainer(), plugin.getPropertyChangeAppenders());
            this.addModule(addOnsModule);
        }
        return additionalTypes;
    }

    private void bootJsonConverter() {
        JsonConverterBuilder jsonConverterBuilder = this.jsonConverterBuilder();
        jsonConverterBuilder.prettyPrint(this.coreConfiguration().isPrettyPrint());
        this.addModule(new ChangeTypeAdaptersModule(this.getContainer()));
        this.addModule(new CommitTypeAdaptersModule(this.getContainer()));
        if (new RequiredMongoSupportPredicate().test(this.repository)) {
            jsonConverterBuilder.registerNativeGsonDeserializer((Type)((Object)Long.class), new MongoLong64JsonDeserializer());
        }
        jsonConverterBuilder.registerJsonTypeAdapters(this.getComponents(JsonTypeAdapter.class));
        jsonConverterBuilder.registerNativeGsonDeserializer((Type)((Object)Diff.class), new DiffTypeDeserializer());
        JsonConverter jsonConverter = jsonConverterBuilder.build();
        this.addComponent(jsonConverter);
    }

    private void bootDateTimeProvider() {
        if (this.dateProvider == null) {
            this.dateProvider = new DefaultDateProvider();
        }
        this.addComponent(this.dateProvider);
    }

    private void bootRepository() {
        CoreConfiguration coreConfiguration = this.coreConfiguration();
        if (this.repository == null) {
            logger.info("using fake InMemoryRepository, register actual Repository implementation via JaversBuilder.registerJaversRepository()");
            this.repository = new InMemoryRepository();
        }
        this.repository.setJsonConverter(this.getContainerComponent(JsonConverter.class));
        if (this.repository instanceof ConfigurationAware) {
            ((ConfigurationAware)((Object)this.repository)).setConfiguration(coreConfiguration);
        }
        this.bindComponent(JaversRepository.class, this.repository);
        this.addComponent(JaversExtendedRepository.class);
    }

    private <T extends ClientsClassDefinition> T getClassDefinition(Class<?> baseJavaClass) {
        return (T)this.clientsClassDefinitions.get(baseJavaClass);
    }

    private CoreConfiguration coreConfiguration() {
        return this.getContainerComponent(CoreConfiguration.class);
    }
}

