/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.object;

import java.util.function.Supplier;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.ValueObjectId;

public abstract class ValueObjectIdWithHash
extends ValueObjectId {
    private static final String HASH_PLACEHOLDER = "{hashPlaceholder}";

    public static boolean containsHashPlaceholder(String fragment) {
        if (fragment == null) {
            return false;
        }
        return fragment.contains(HASH_PLACEHOLDER);
    }

    public ValueObjectIdWithHash(String typeName, GlobalId ownerId, String fragment) {
        super(typeName, ownerId, fragment);
    }

    public abstract boolean requiresHash();

    public abstract boolean hasHashOnParent();

    public abstract ValueObjectId applyHash();

    public abstract ValueObjectId applyHash(String var1);

    public ValueObjectId freeze() {
        return new ValueObjectId(this.getTypeName(), this.getOwnerId(), this.getFragment());
    }

    @Override
    public String toString() {
        return this.getOwnerId().toString() + "#" + this.getFragment() + " (" + this.getClass().getSimpleName() + ")";
    }

    static class ValueObjectIdWithPlaceholder
    extends ValueObjectIdWithHash {
        private final Supplier<String> parentFragment;
        private final String localPath;
        private String hash;
        private final boolean requiresHash;
        private final boolean hasHashOnParent;

        ValueObjectIdWithPlaceholder(String typeName, GlobalId ownerId, Supplier<String> parentFragment, String localPath, boolean requiresHash) {
            super(typeName, ownerId, parentFragment.get() + localPath + (requiresHash ? "/{hashPlaceholder}" : ""));
            this.parentFragment = parentFragment;
            this.localPath = localPath;
            this.hash = requiresHash ? ValueObjectIdWithHash.HASH_PLACEHOLDER : "";
            this.requiresHash = requiresHash;
            this.hasHashOnParent = ValueObjectIdWithPlaceholder.containsHashPlaceholder(parentFragment.get());
        }

        @Override
        public ValueObjectId applyHash(String hash) {
            Validate.conditionFulfilled(this.requiresHash, "Illegal state - hash not required");
            if (!ValueObjectIdWithHash.HASH_PLACEHOLDER.equals(this.hash)) {
                throw new JaversException(JaversExceptionCode.RUNTIME_EXCEPTION, "already frozen");
            }
            this.hash = hash;
            if (!this.hasHashOnParent()) {
                return new ValueObjectId(this.getTypeName(), this.getOwnerId(), this.getFragment());
            }
            return new ValueObjectIdWithPlaceholder(this.getTypeName(), this.getOwnerId(), this.parentFragment, this.localPath + "/" + hash, false);
        }

        @Override
        public ValueObjectId applyHash() {
            Validate.conditionFulfilled(!this.requiresHash, "Illegal state - hash required");
            if (this.getFragment().contains(ValueObjectIdWithHash.HASH_PLACEHOLDER)) {
                throw new JaversException(JaversExceptionCode.RUNTIME_EXCEPTION, "can't freeze ValueObjectId, there is still a hash in parent fragment");
            }
            return new ValueObjectId(this.getTypeName(), this.getOwnerId(), this.getFragment());
        }

        @Override
        public boolean requiresHash() {
            return this.requiresHash;
        }

        @Override
        public boolean hasHashOnParent() {
            return this.hasHashOnParent;
        }

        @Override
        public String getFragment() {
            if (this.requiresHash) {
                return this.parentFragment.get() + this.localPath + "/" + this.hash;
            }
            return this.parentFragment.get() + this.localPath;
        }
    }
}

