/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.util.function.Supplier;
import org.javers.common.string.ToStringBuilder;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.CustomType;
import org.javers.core.metamodel.type.EntityType;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.PrimitiveOrValueType;
import org.javers.core.metamodel.type.ShallowReferenceType;
import org.javers.core.metamodel.type.ValueObjectType;

public class JaversProperty
extends Property {
    private final Supplier<JaversType> propertyType;

    public JaversProperty(Supplier<JaversType> propertyType, Property property) {
        super(property.getMember(), property.hasTransientAnn(), property.hasShallowReferenceAnn(), property.getName(), property.isHasIncludedAnn());
        this.propertyType = propertyType;
    }

    public <T extends JaversType> T getType() {
        return (T)this.propertyType.get();
    }

    public boolean isEntityType() {
        return this.getType() instanceof EntityType;
    }

    public boolean isValueObjectType() {
        return this.getType() instanceof ValueObjectType;
    }

    public boolean isPrimitiveOrValueType() {
        return this.getType() instanceof PrimitiveOrValueType;
    }

    public boolean isCustomType() {
        return this.getType() instanceof CustomType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JaversProperty that = (JaversProperty)o;
        return super.equals(that) && ((JaversType)this.getType()).equals(that.getType());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public boolean isShallowReference() {
        return this.hasShallowReferenceAnn() || this.getType() instanceof ShallowReferenceType;
    }

    @Override
    public String toString() {
        return this.getMember().memberType() + " " + this.getType().getClass().getSimpleName() + ":" + ToStringBuilder.typeName(this.getMember().getGenericResolvedType()) + " " + this.getName() + (this.getMember().memberType().equals("Getter") ? "()" : "") + ", declared in " + this.getDeclaringClass().getSimpleName();
    }
}

