/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.scanner;

import java.util.Collection;
import org.javers.common.collections.Lists;
import org.javers.core.CoreConfiguration;
import org.javers.core.JaversBuilder;
import org.javers.core.MappingStyle;
import org.javers.core.metamodel.scanner.AnnotationNamesProvider;
import org.javers.core.metamodel.scanner.BeanBasedPropertyScanner;
import org.javers.core.metamodel.scanner.ClassAnnotationsScanner;
import org.javers.core.metamodel.scanner.ClassScanner;
import org.javers.core.metamodel.scanner.FieldBasedPropertyScanner;
import org.javers.core.pico.LateInstantiatingModule;
import org.picocontainer.MutablePicoContainer;
import org.slf4j.Logger;

public class ScannerModule
extends LateInstantiatingModule {
    private static final Logger logger = JaversBuilder.logger;

    public ScannerModule(CoreConfiguration configuration, MutablePicoContainer container) {
        super(configuration, container);
    }

    @Override
    protected Collection<Class> getImplementations() {
        Class usedPropertyScanner;
        MappingStyle mappingStyle = this.getConfiguration().getMappingStyle();
        logger.info("mappingStyle: " + mappingStyle.name());
        if (mappingStyle == MappingStyle.BEAN) {
            usedPropertyScanner = BeanBasedPropertyScanner.class;
        } else if (mappingStyle == MappingStyle.FIELD) {
            usedPropertyScanner = FieldBasedPropertyScanner.class;
        } else {
            throw new RuntimeException("not implementation for " + (Object)((Object)mappingStyle));
        }
        return Lists.asList(ClassScanner.class, ClassAnnotationsScanner.class, AnnotationNamesProvider.class, usedPropertyScanner);
    }
}

