/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.javers.common.collections.Lists;
import org.javers.common.string.PrettyValuePrinter;
import org.javers.common.validation.Validate;
import org.javers.core.ChangesByCommit;
import org.javers.core.ChangesByObject;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.diff.Change;
import org.javers.core.diff.changetype.PropertyChange;
import org.javers.core.metamodel.object.GlobalId;

public class Changes
extends AbstractList<Change>
implements Serializable {
    private final List<Change> changes;
    private final transient PrettyValuePrinter valuePrinter;

    public Changes(List<Change> changes, PrettyValuePrinter valuePrinter) {
        Validate.argumentsAreNotNull(changes, valuePrinter);
        this.changes = Collections.unmodifiableList(changes);
        this.valuePrinter = valuePrinter;
    }

    public List<ChangesByCommit> groupByCommit() {
        if (this.changes.size() == 0) {
            return Collections.emptyList();
        }
        if (!this.changes.get(0).getCommitMetadata().isPresent()) {
            return Lists.immutableListOf(new ChangesByCommit(CommitMetadata.nullObject(), this.changes, this.valuePrinter));
        }
        Map changesByCommit = this.changes.stream().collect(Collectors.groupingBy(c -> c.getCommitMetadata().orElseThrow(() -> new IllegalStateException("No CommitMetadata in this Change")), () -> new LinkedHashMap(), Collectors.toList()));
        ArrayList result = new ArrayList();
        changesByCommit.forEach((? super K k, ? super V v) -> result.add(new ChangesByCommit((CommitMetadata)k, (List<Change>)v, this.valuePrinter)));
        return Collections.unmodifiableList(result);
    }

    public List<PropertyChange> getPropertyChanges(String propertyName) {
        return this.changes.stream().filter(it -> it instanceof PropertyChange && ((PropertyChange)it).getPropertyName().equals(propertyName)).collect(Collectors.toList());
    }

    public List<ChangesByObject> groupByObject() {
        Map<GlobalId, List<Change>> changesByObject = this.changes.stream().collect(Collectors.groupingBy(c -> c.getAffectedGlobalId().masterObjectId()));
        ArrayList result = new ArrayList();
        changesByObject.forEach((? super K k, ? super V v) -> result.add(new ChangesByObject((GlobalId)k, (List<Change>)v, this.valuePrinter)));
        return Collections.unmodifiableList(result);
    }

    @Override
    public Change get(int index) {
        return this.changes.get(index);
    }

    @Override
    public int size() {
        return this.changes.size();
    }

    public <C extends Change> List<C> getChangesByType(Class<C> type) {
        Validate.argumentIsNotNull(type);
        return Collections.unmodifiableList(this.changes.stream().filter(input -> type.isAssignableFrom(input.getClass())).collect(Collectors.toList()));
    }

    @Override
    public String toString() {
        return this.devPrint();
    }

    public final String prettyPrint() {
        StringBuilder b = new StringBuilder();
        b.append("Changes:\n");
        for (ChangesByCommit c : this.groupByCommit()) {
            b.append(c.prettyPrint());
        }
        return b.toString();
    }

    public String devPrint() {
        StringBuilder b = new StringBuilder();
        b.append("Changes (" + this.size() + "):\n");
        this.groupByCommit().forEach(byCommit -> {
            b.append("commit " + byCommit.getCommit().getId() + " \n");
            byCommit.groupByObject().forEach(byObject -> {
                b.append("* changes on " + byObject.getGlobalId().value() + " :\n");
                byObject.get().forEach(change -> b.append("  - " + change + " \n"));
            });
        });
        return b.toString();
    }
}

