/*
 * Decompiled with CFR 0.152.
 */
package org.javers.guava;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.core.diff.NodePair;
import org.javers.core.diff.appenders.CorePropertyChangeAppender;
import org.javers.core.diff.appenders.PropertyChangeAppender;
import org.javers.core.diff.changetype.map.EntryAdded;
import org.javers.core.diff.changetype.map.EntryChange;
import org.javers.core.diff.changetype.map.EntryRemoved;
import org.javers.core.diff.changetype.map.MapChange;
import org.javers.core.metamodel.object.OwnerContext;
import org.javers.core.metamodel.object.PropertyOwnerContext;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.KeyValueType;
import org.javers.core.metamodel.type.TypeMapper;
import org.javers.core.metamodel.type.ValueObjectType;
import org.javers.guava.MultimapType;
import org.javers.guava.Multimaps;

class MultimapChangeAppender
implements PropertyChangeAppender<MapChange> {
    private final TypeMapper typeMapper;

    MultimapChangeAppender(TypeMapper typeMapper) {
        this.typeMapper = typeMapper;
    }

    @Override
    public boolean supports(JaversType propertyType) {
        if (!(propertyType instanceof MultimapType)) {
            return false;
        }
        KeyValueType keyValueType = (KeyValueType)propertyType;
        if (keyValueType.getKeyJaversType() instanceof ValueObjectType) {
            throw new JaversException(JaversExceptionCode.VALUE_OBJECT_IS_NOT_SUPPORTED_AS_MAP_KEY, propertyType);
        }
        return true;
    }

    @Override
    public MapChange calculateChanges(NodePair pair, JaversProperty property) {
        PropertyOwnerContext owner;
        Multimap left = (Multimap)pair.getLeftDehydratedPropertyValueAndSanitize(property);
        Multimap right = (Multimap)pair.getRightDehydratedPropertyValueAndSanitize(property);
        MultimapType multimapType = (MultimapType)property.getType();
        List<EntryChange> entryChanges = this.calculateChanges(multimapType, left, right, owner = new PropertyOwnerContext(pair.getGlobalId(), property.getName()));
        if (!entryChanges.isEmpty()) {
            CorePropertyChangeAppender.renderNotParametrizedWarningIfNeeded(multimapType.getKeyJavaType(), "key", "Multimap", property);
            CorePropertyChangeAppender.renderNotParametrizedWarningIfNeeded(multimapType.getValueJavaType(), "value", "Multimap", property);
            return new MapChange<Object>(pair.createPropertyChangeMetadata(property), entryChanges, null, null);
        }
        return null;
    }

    private List<EntryChange> calculateChanges(MultimapType multimapType, Multimap left, Multimap right, OwnerContext owner) {
        ArrayList<EntryChange> changes = new ArrayList<EntryChange>();
        for (Object commonKey : Multimaps.commonKeys(left, right)) {
            Collection leftValues = left.get(commonKey);
            Collection rightValues = right.get(commonKey);
            Collection difference = MultimapChangeAppender.difference(leftValues, rightValues);
            difference.addAll(MultimapChangeAppender.difference(rightValues, leftValues));
            if (difference.size() <= 0) continue;
            this.calculateValueChanges(changes, commonKey, leftValues, rightValues);
        }
        this.calculateKeyChanges(left, right, changes);
        return changes;
    }

    private static Collection difference(Collection first, Collection second) {
        if (first == null) {
            return Collections.EMPTY_LIST;
        }
        if (second == null) {
            return first;
        }
        ArrayList difference = new ArrayList(first);
        for (Object current : second) {
            difference.remove(current);
        }
        return difference;
    }

    private void calculateKeyChanges(Multimap leftMultimap, Multimap rightMultimap, List<EntryChange> changes) {
        for (Object addedKey : Multimaps.keysDifference(rightMultimap, leftMultimap)) {
            Collection difference = MultimapChangeAppender.difference(rightMultimap.get(addedKey), leftMultimap.get(addedKey));
            for (Object addedValue : difference) {
                changes.add(new EntryAdded(addedKey, addedValue));
            }
        }
        for (Object removedKey : Multimaps.keysDifference(leftMultimap, rightMultimap)) {
            for (Object removedValue : MultimapChangeAppender.difference(leftMultimap.get(removedKey), rightMultimap.get(removedKey))) {
                changes.add(new EntryRemoved(removedKey, removedValue));
            }
        }
    }

    private void calculateValueChanges(List<EntryChange> changes, Object commonKey, Collection leftVal, Collection rightVal) {
        Collection valuesAdded;
        if (Objects.equals(leftVal, rightVal)) {
            return;
        }
        Collection valuesRemoved = MultimapChangeAppender.difference(leftVal, rightVal);
        if (valuesRemoved.size() > 0) {
            for (Object addedValue : valuesRemoved) {
                changes.add(new EntryRemoved(commonKey, addedValue));
            }
        }
        if ((valuesAdded = MultimapChangeAppender.difference(rightVal, leftVal)).size() > 0) {
            for (Object addedValue : valuesAdded) {
                changes.add(new EntryAdded(commonKey, addedValue));
            }
        }
    }
}

