/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.appenders;

import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.type.CustomComparableType;
import org.javers.core.metamodel.type.JaversType;

public class HashWrapper {
    private final Object target;
    private final BiFunction<Object, Object, Boolean> equalsFunction;
    private final Function<Object, String> toStringFunction;

    public HashWrapper(Object target, BiFunction<Object, Object, Boolean> equalsFunction, Function<Object, String> toStringFunction) {
        Validate.argumentIsNotNull(equalsFunction);
        Validate.argumentIsNotNull(toStringFunction);
        this.target = target;
        this.equalsFunction = equalsFunction;
        this.toStringFunction = toStringFunction;
    }

    public boolean equals(Object that) {
        return this.equalsFunction.apply(this.target, ((HashWrapper)that).target);
    }

    public int hashCode() {
        return this.toStringFunction.apply(this.target).hashCode();
    }

    public Object unwrap() {
        return this.target;
    }

    public static Set wrapValuesIfNeeded(Set set, JaversType itemType) {
        if (HashWrapper.hasCustomValueComparator(itemType)) {
            CustomComparableType customType = (CustomComparableType)((Object)itemType);
            return set.stream().map(it -> new HashWrapper(it, itemType::equals, customType::valueToString)).collect(Collectors.toSet());
        }
        return set;
    }

    public static Map wrapKeysIfNeeded(Map map, JaversType keyType) {
        if (HashWrapper.hasCustomValueComparator(keyType)) {
            CustomComparableType customType = (CustomComparableType)((Object)keyType);
            return map.entrySet().stream().collect(Collectors.toMap(e -> new HashWrapper(((Map.Entry)e).getKey(), keyType::equals, customType::valueToString), e -> ((Map.Entry)e).getValue()));
        }
        return map;
    }

    private static boolean hasCustomValueComparator(JaversType javersType) {
        return javersType instanceof CustomComparableType && ((CustomComparableType)((Object)javersType)).hasCustomValueComparator();
    }
}

