/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.jql;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.javers.common.collections.Lists;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.repository.jql.JqlQuery;
import org.javers.repository.jql.QueryCompiler;
import org.javers.repository.jql.ShadowQueryRunner;
import org.javers.shadow.Shadow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ShadowStreamQueryRunner {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.javers.JQL");
    private final ShadowQueryRunner shadowQueryRunner;
    private final QueryCompiler queryCompiler;

    public ShadowStreamQueryRunner(ShadowQueryRunner shadowQueryRunner, QueryCompiler queryCompiler) {
        this.shadowQueryRunner = shadowQueryRunner;
        this.queryCompiler = queryCompiler;
    }

    Stream<Shadow> queryForShadowsStream(JqlQuery query) {
        int shadowsLimit = query.getQueryParams().limit();
        int shadowsSkip = query.getQueryParams().skip();
        int characteristics = 1040;
        StreamQuery streamQuery = new StreamQuery(query, shadowsLimit);
        Spliterator<Shadow> spliterator = Spliterators.spliteratorUnknownSize(streamQuery.lazyIterator(), characteristics);
        Stream<Shadow> stream = StreamSupport.stream(spliterator, false);
        if (shadowsSkip > 0) {
            stream = stream.skip(shadowsSkip);
        }
        query.setShadowQueryRunnerStats(streamQuery.streamStats);
        return stream;
    }

    public static class ShadowStreamStats
    extends ShadowQueryRunner.ShadowStats {
        private final List<ShadowQueryRunner.ShadowStats> frameQueriesStats = new ArrayList<ShadowQueryRunner.ShadowStats>();

        void addNextFrameStats(ShadowQueryRunner.ShadowStats next) {
            this.frameQueriesStats.add(next);
        }

        int size() {
            return this.frameQueriesStats.size();
        }

        ShadowQueryRunner.ShadowStats getFirstFrameStats() {
            if (this.frameQueriesStats.isEmpty()) {
                return null;
            }
            return this.frameQueriesStats.get(0);
        }

        public List<ShadowQueryRunner.ShadowStats> getFrameQueriesStats() {
            return Collections.unmodifiableList(this.frameQueriesStats);
        }

        @Override
        List<Object> toStringProps() {
            return Lists.join(super.toStringProps(), Lists.asList("Shadow stream frame queries", this.getShadowQueriesCount()));
        }

        @Override
        public long getStartTimestamp() {
            return this.frameQueriesStats.get(0).getStartTimestamp();
        }

        @Override
        public long getEndTimestamp() {
            if (this.frameQueriesStats.size() == 0) {
                return 0L;
            }
            return this.frameQueriesStats.get(this.frameQueriesStats.size() - 1).getEndTimestamp();
        }

        @Override
        public int getDbQueriesCount() {
            return this.frameQueriesStats.stream().mapToInt(it -> it.getDbQueriesCount()).sum();
        }

        public int getShadowQueriesCount() {
            return this.frameQueriesStats.size();
        }

        @Override
        public int getAllSnapshotsCount() {
            return this.frameQueriesStats.stream().mapToInt(it -> it.getAllSnapshotsCount()).sum();
        }

        @Override
        public int getShallowSnapshotsCount() {
            return this.frameQueriesStats.stream().mapToInt(it -> it.getShallowSnapshotsCount()).sum();
        }

        @Override
        public int getDeepPlusSnapshotsCount() {
            return this.frameQueriesStats.stream().mapToInt(it -> it.getDeepPlusSnapshotsCount()).sum();
        }

        @Override
        public int getCommitDeepSnapshotsCount() {
            return this.frameQueriesStats.stream().mapToInt(it -> it.getCommitDeepSnapshotsCount()).sum();
        }

        @Override
        public int getChildVOSnapshotsCount() {
            return this.frameQueriesStats.stream().mapToInt(it -> it.getChildVOSnapshotsCount()).sum();
        }

        @Override
        public int getDeepPlusGapsFilled() {
            return this.frameQueriesStats.stream().mapToInt(it -> it.getDeepPlusGapsFilled()).sum();
        }

        @Override
        public int getDeepPlusGapsLeft() {
            return this.frameQueriesStats.stream().mapToInt(it -> it.getDeepPlusGapsLeft()).sum();
        }
    }

    private class StreamQuery {
        private JqlQuery awaitingQuery;
        private ShadowStreamStats streamStats = new ShadowStreamStats();
        private final List<CdoSnapshot> filledGapsSnapshots = new ArrayList<CdoSnapshot>();
        private final int snapshotBatchSize;
        private final int shadowsLimit;

        StreamQuery(JqlQuery initialQuery, int shadowsLimit) {
            Validate.argumentIsNotNull(initialQuery);
            this.snapshotBatchSize = initialQuery.getQueryParams().snapshotQueryLimit().orElse(100);
            ShadowStreamQueryRunner.this.queryCompiler.compile(initialQuery);
            initialQuery.changeToAggregatedIfEntityQuery();
            this.awaitingQuery = initialQuery.changeLimit(this.snapshotBatchSize, 0);
            this.shadowsLimit = shadowsLimit;
        }

        List<Shadow> loadNextPage() {
            JqlQuery currentQuery = this.awaitingQuery;
            ShadowQueryRunner.ShadowQueryResult result = ShadowStreamQueryRunner.this.shadowQueryRunner.queryForShadows(currentQuery, this.filledGapsSnapshots);
            logger.debug("Shadow stream query (frame " + (this.streamStats.size() + 1) + ") executed:\nJqlQuery {\n  " + currentQuery.getFilterDefinition() + "\n  " + currentQuery.getQueryParams() + "\n  shadowScope: " + (Object)((Object)currentQuery.getShadowScope()) + "\n  " + result.getQueryStats() + "\n}");
            this.streamStats.addNextFrameStats(result.getQueryStats());
            this.filledGapsSnapshots.addAll(result.getFilledGapsSnapshots());
            this.awaitingQuery = currentQuery.nextQueryForStream();
            return result.getShadows();
        }

        Iterator<Shadow> lazyIterator() {
            return new LazyIterator();
        }

        class LazyIterator
        implements Iterator<Shadow> {
            private boolean terminated = false;
            Deque<Shadow> shadowsToGo = new ArrayDeque<Shadow>();
            private int nextIdx = 0;
            private boolean noMorePages;

            LazyIterator() {
            }

            @Override
            public boolean hasNext() {
                if (this.nextIdx == StreamQuery.this.shadowsLimit) {
                    this.terminate();
                    return false;
                }
                if (this.shadowsToGo.size() > 0) {
                    return true;
                }
                if (this.noMorePages) {
                    return false;
                }
                List<Shadow> nextPage = StreamQuery.this.loadNextPage();
                if (nextPage.size() < StreamQuery.this.snapshotBatchSize) {
                    this.noMorePages = true;
                }
                if (nextPage.size() == 0) {
                    this.terminate();
                    return false;
                }
                this.shadowsToGo.addAll(nextPage);
                return true;
            }

            private void terminate() {
                this.shadowsToGo.clear();
                this.terminated = true;
            }

            @Override
            public Shadow next() {
                if (this.terminated) {
                    throw new IllegalStateException("attempt to read from the terminated iterator");
                }
                Shadow result = this.shadowsToGo.poll();
                ++this.nextIdx;
                return result;
            }
        }
    }
}

