/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.jql;

import java.util.List;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.core.diff.Change;
import org.javers.repository.api.JaversExtendedRepository;
import org.javers.repository.jql.JqlQuery;
import org.javers.repository.jql.QueryCompiler;
import org.javers.repository.jql.VoOwnerFilter;

class ChangesQueryRunner {
    private final QueryCompiler queryCompiler;
    private final JaversExtendedRepository repository;

    ChangesQueryRunner(QueryCompiler queryCompiler, JaversExtendedRepository repository) {
        this.queryCompiler = queryCompiler;
        this.repository = repository;
    }

    List<Change> queryForChanges(JqlQuery query) {
        this.queryCompiler.compile(query);
        if (query.isAnyDomainObjectQuery()) {
            return this.repository.getChanges(query.isNewObjectChanges(), query.getQueryParams());
        }
        if (query.isIdQuery()) {
            return this.repository.getChangeHistory(query.getIdFilter(), query.getQueryParams());
        }
        if (query.isClassQuery()) {
            return this.repository.getChangeHistory(query.getClassFilter(), query.getQueryParams());
        }
        if (query.isVoOwnerQuery()) {
            VoOwnerFilter filter = query.getVoOwnerFilter();
            return this.repository.getValueObjectChangeHistory(filter.getOwnerEntity(), filter.getPath(), query.getQueryParams());
        }
        throw new JaversException(JaversExceptionCode.MALFORMED_JQL, "queryForChanges: " + query + " is not supported");
    }
}

