/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.jql;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.javers.core.diff.Change;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.repository.jql.ChangesQueryRunner;
import org.javers.repository.jql.GlobalIdDTO;
import org.javers.repository.jql.JqlQuery;
import org.javers.repository.jql.ShadowQueryRunner;
import org.javers.repository.jql.ShadowStreamQueryRunner;
import org.javers.repository.jql.SnapshotQueryRunner;
import org.javers.shadow.Shadow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryRunner {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.javers.JQL");
    private final ChangesQueryRunner changesQueryRunner;
    private final SnapshotQueryRunner snapshotQueryRunner;
    private final ShadowQueryRunner shadowQueryRunner;
    private final ShadowStreamQueryRunner shadowStreamQueryRunner;

    QueryRunner(ChangesQueryRunner changesQueryRunner, SnapshotQueryRunner snapshotQueryRunner, ShadowQueryRunner shadowQueryRunner, ShadowStreamQueryRunner shadowStreamQueryRunner) {
        this.changesQueryRunner = changesQueryRunner;
        this.snapshotQueryRunner = snapshotQueryRunner;
        this.shadowQueryRunner = shadowQueryRunner;
        this.shadowStreamQueryRunner = shadowStreamQueryRunner;
    }

    public Stream<Shadow> queryForShadowsStream(JqlQuery query) {
        return this.shadowStreamQueryRunner.queryForShadowsStream(query);
    }

    public List<Shadow> queryForShadows(JqlQuery query) {
        return this.shadowQueryRunner.queryForShadows(query);
    }

    public Optional<CdoSnapshot> runQueryForLatestSnapshot(GlobalIdDTO globalId) {
        return this.snapshotQueryRunner.runQueryForLatestSnapshot(globalId);
    }

    public List<CdoSnapshot> queryForSnapshots(JqlQuery query) {
        return this.snapshotQueryRunner.queryForSnapshots(query);
    }

    public List<Change> queryForChanges(JqlQuery query) {
        return this.changesQueryRunner.queryForChanges(query);
    }
}

