/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.javers.common.collections.EnumerableFunction;
import org.javers.common.collections.Lists;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.OwnerContext;
import org.javers.core.metamodel.type.CollectionType;
import org.javers.core.metamodel.type.IndexableEnumerationOwnerContext;

public class ListType
extends CollectionType {
    public ListType(Type baseJavaType) {
        super(baseJavaType);
    }

    @Override
    public Object map(Object sourceEnumerable, EnumerableFunction mapFunction, OwnerContext owner) {
        Validate.argumentsAreNotNull(mapFunction, owner);
        List sourceList = Lists.wrapNull(sourceEnumerable);
        ArrayList<Object> targetList = new ArrayList<Object>(sourceList.size());
        IndexableEnumerationOwnerContext enumerationContext = new IndexableEnumerationOwnerContext(owner);
        for (Object sourceVal : sourceList) {
            targetList.add(sourceVal == null ? null : (Object)mapFunction.apply(sourceVal, enumerationContext));
        }
        return Collections.unmodifiableList(targetList);
    }

    @Override
    public Object map(Object sourceEnumerable, Function mapFunction, boolean filterNulls) {
        List sourceCol = Lists.wrapNull(sourceEnumerable);
        return Collections.unmodifiableList(sourceCol.stream().map(sourceVal -> sourceVal == null ? null : mapFunction.apply(sourceVal)).filter(mappedVal -> !filterNulls || mappedVal != null).collect(Collectors.toList()));
    }

    @Override
    public Class<?> getEnumerableInterface() {
        return List.class;
    }
}

