/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.common.validation.Validate;
import org.javers.core.JaversCoreConfiguration;
import org.javers.core.metamodel.clazz.ClientsClassDefinition;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.scanner.ClassScanner;
import org.javers.core.metamodel.type.ClassType;
import org.javers.core.metamodel.type.ContainerType;
import org.javers.core.metamodel.type.DehydratedTypeFactory;
import org.javers.core.metamodel.type.DuckType;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.KeyValueType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.MapContentType;
import org.javers.core.metamodel.type.ShallowReferenceType;
import org.javers.core.metamodel.type.TypeFactory;
import org.javers.core.metamodel.type.TypeMapperEngine;
import org.javers.core.metamodel.type.ValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeMapper {
    static final Logger logger = LoggerFactory.getLogger((String)"org.javers.TypeMapper");
    static final ValueType OBJECT_TYPE = new ValueType((Type)((Object)Object.class));
    private final TypeMapperEngine engine = new TypeMapperEngine();
    private final TypeFactory typeFactory;
    private final DehydratedTypeFactory dehydratedTypeFactory = new DehydratedTypeFactory(this);

    public TypeMapper(ClassScanner classScanner, JaversCoreConfiguration javersCoreConfiguration) {
        TypeFactory typeFactory = new TypeFactory(classScanner, this);
        this.engine.registerCoreTypes(javersCoreConfiguration.getListCompareAlgorithm());
        this.typeFactory = typeFactory;
    }

    @Deprecated
    protected TypeMapper(TypeFactory typeFactory) {
        this.typeFactory = typeFactory;
    }

    public MapContentType getMapContentType(KeyValueType mapType) {
        JaversType keyType = this.getJaversType(mapType.getKeyType());
        JaversType valueType = this.getJaversType(mapType.getValueType());
        return new MapContentType(keyType, valueType);
    }

    public MapContentType getMapContentType(ContainerType containerType) {
        JaversType keyType = this.getJaversType((Type)((Object)Integer.class));
        JaversType valueType = this.getJaversType(containerType.getItemType());
        return new MapContentType(keyType, valueType);
    }

    public JaversType getContainerItemType(JaversProperty property) {
        ContainerType containerType = (ContainerType)property.getType();
        return this.getJaversType(containerType.getItemType());
    }

    public boolean isContainerOfManagedTypes(JaversType javersType) {
        if (!(javersType instanceof ContainerType)) {
            return false;
        }
        return this.getJaversType(((ContainerType)javersType).getItemType()) instanceof ManagedType;
    }

    public boolean isKeyValueTypeWithManagedTypes(JaversType enumerableType) {
        if (enumerableType instanceof KeyValueType) {
            KeyValueType mapType = (KeyValueType)enumerableType;
            JaversType keyType = this.getJaversType(mapType.getKeyType());
            JaversType valueType = this.getJaversType(mapType.getValueType());
            return keyType instanceof ManagedType || valueType instanceof ManagedType;
        }
        return false;
    }

    public boolean isManagedType(JaversType javersType) {
        return javersType instanceof ManagedType;
    }

    public boolean isEnumerableOfManagedTypes(JaversType javersType) {
        return this.isContainerOfManagedTypes(javersType) || this.isKeyValueTypeWithManagedTypes(javersType);
    }

    public JaversType getJaversType(Type javaType) {
        Validate.argumentIsNotNull(javaType);
        if (javaType == Object.class) {
            return OBJECT_TYPE;
        }
        return this.engine.computeIfAbsent(javaType, j -> this.typeFactory.infer((Type)j, this.findPrototype((Type)j)));
    }

    public boolean isShallowReferenceType(Type javaType) {
        return this.getJaversType(javaType) instanceof ShallowReferenceType;
    }

    public ClassType getJaversClassType(Type javaType) {
        Validate.argumentIsNotNull(javaType);
        JaversType jType = this.getJaversType(javaType);
        if (jType instanceof ClassType) {
            return (ClassType)jType;
        }
        throw new JaversException(JaversExceptionCode.CLASS_MAPPING_ERROR, javaType, jType.getClass().getSimpleName(), ClassType.class.getSimpleName());
    }

    public ManagedType getJaversManagedType(GlobalId globalId) {
        return this.getJaversManagedType(this.engine.getClassByTypeName(globalId.getTypeName()), ManagedType.class);
    }

    public <T extends ManagedType> T getJaversManagedType(String typeName, Class<T> expectedType) {
        return this.getJaversManagedType(this.engine.getClassByTypeName(typeName), expectedType);
    }

    private <T extends ManagedType> T getJaversManagedType(String typeName) {
        return (T)this.getJaversManagedType(this.engine.getClassByTypeName(typeName), ManagedType.class);
    }

    public <T extends ManagedType> T getJaversManagedType(DuckType duckType, Class<T> expectedType) {
        return this.getJaversManagedType(this.engine.getClassByDuckType(duckType), expectedType);
    }

    public ManagedType getJaversManagedType(Class javaType) {
        return this.getJaversManagedType(javaType, ManagedType.class);
    }

    public <T extends ManagedType> T getJaversManagedType(Class javaClass, Class<T> expectedType) {
        JaversType mType = this.getJaversType(javaClass);
        if (expectedType.isAssignableFrom(mType.getClass())) {
            return (T)((ManagedType)mType);
        }
        throw new JaversException(JaversExceptionCode.MANAGED_CLASS_MAPPING_ERROR, javaClass, mType.getClass().getSimpleName(), expectedType.getSimpleName());
    }

    public <T extends ManagedType> Optional<T> getJaversManagedTypeMaybe(String typeName, Class<T> expectedType) {
        return this.getJaversManagedTypeMaybe(new DuckType(typeName), expectedType);
    }

    public <T extends ManagedType> Optional<T> getJaversManagedTypeMaybe(DuckType duckType, Class<T> expectedType) {
        try {
            return Optional.of(this.getJaversManagedType(duckType, expectedType));
        }
        catch (JaversException e) {
            if (JaversExceptionCode.TYPE_NAME_NOT_FOUND == e.getCode()) {
                return Optional.empty();
            }
            if (JaversExceptionCode.MANAGED_CLASS_MAPPING_ERROR == e.getCode()) {
                return Optional.empty();
            }
            throw e;
        }
    }

    public <T extends JaversType> T getPropertyType(Property property) {
        Validate.argumentIsNotNull(property);
        try {
            return (T)this.getJaversType(property.getGenericType());
        }
        catch (JaversException e) {
            logger.error("Can't calculate JaversType for property: {}", (Object)property);
            throw e;
        }
    }

    public void registerClientsClass(ClientsClassDefinition def) {
        JaversType newType = this.typeFactory.create(def);
        logger.debug("javersType of '{}' mapped explicitly to {}", (Object)def.getBaseJavaClass().getSimpleName(), (Object)newType.getClass().getSimpleName());
        this.engine.registerExplicitType(newType);
    }

    public Type getDehydratedType(Type type) {
        return this.dehydratedTypeFactory.build(type);
    }

    public void addPluginTypes(Collection<JaversType> jTypes) {
        Validate.argumentIsNotNull(jTypes);
        for (JaversType t : jTypes) {
            this.engine.registerExplicitType(t);
        }
    }

    boolean contains(Type javaType) {
        return this.engine.contains(javaType);
    }

    private Optional<JaversType> findPrototype(Type javaType) {
        if (javaType instanceof TypeVariable) {
            return Optional.empty();
        }
        Class javaClass = ReflectionUtil.extractClass(javaType);
        if (javaClass.isArray()) {
            return Optional.of(this.getJaversType((Type)((Object)Object[].class)));
        }
        JaversType selfClassType = this.engine.get(javaClass);
        if (selfClassType != null && javaClass != javaType) {
            return Optional.of(selfClassType);
        }
        List<Type> hierarchy = ReflectionUtil.calculateHierarchyDistance(javaClass);
        for (Type parent : hierarchy) {
            JaversType jType = this.engine.get(parent);
            if (jType == null || !jType.canBePrototype()) continue;
            logger.debug("proto for {} -> {}", (Object)javaType, (Object)jType);
            return Optional.of(jType);
        }
        return Optional.empty();
    }
}

