/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.appenders;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import org.javers.common.collections.Lists;
import org.javers.core.diff.NodePair;
import org.javers.core.diff.appenders.PropertyChangeAppender;
import org.javers.core.diff.appenders.SetChangeAppender;
import org.javers.core.diff.changetype.container.ContainerElementChange;
import org.javers.core.diff.changetype.container.ListChange;
import org.javers.core.diff.changetype.container.SetChange;
import org.javers.core.diff.changetype.container.ValueAdded;
import org.javers.core.diff.changetype.container.ValueRemoved;
import org.javers.core.metamodel.type.CustomType;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ListAsSetType;
import org.javers.core.metamodel.type.TypeMapper;

public class ListAsSetChangeAppender
implements PropertyChangeAppender<ListChange> {
    private final TypeMapper typeMapper;
    private final SetChangeAppender setChangeAppender;

    public ListAsSetChangeAppender(TypeMapper typeMapper, SetChangeAppender setChangeAppender) {
        this.typeMapper = typeMapper;
        this.setChangeAppender = setChangeAppender;
    }

    @Override
    public boolean supports(JaversType propertyType) {
        return propertyType instanceof ListAsSetType;
    }

    @Override
    public ListChange calculateChanges(NodePair pair, JaversProperty property) {
        SetChange setChange = null;
        ListAsSetType listType = (ListAsSetType)property.getType();
        JaversType itemType = this.typeMapper.getJaversType(listType.getItemType());
        if (itemType instanceof CustomType) {
            List rightList;
            CustomType ct = (CustomType)itemType;
            List leftList = (List)pair.getLeftDehydratedPropertyValueAndSanitize(property);
            List<ContainerElementChange> entryChanges = this.calculateDiffWithCustomEquals(leftList, rightList = (List)pair.getRightDehydratedPropertyValueAndSanitize(property), (a, b) -> ct.equals(a, b));
            if (entryChanges.size() > 0) {
                return new ListChange(pair.createPropertyChangeMetadata(property), entryChanges);
            }
        } else {
            setChange = this.setChangeAppender.calculateChanges(pair, property);
            if (setChange != null) {
                return new ListChange(pair.createPropertyChangeMetadata(property), setChange.getChanges());
            }
        }
        return null;
    }

    private List<ContainerElementChange> calculateDiffWithCustomEquals(List leftList, List rightList, BiFunction<?, ?, Boolean> equalsFunction) {
        ArrayList<ContainerElementChange> changes = new ArrayList<ContainerElementChange>();
        Lists.difference(leftList, rightList, equalsFunction).forEach(valueOrId -> changes.add(new ValueRemoved(valueOrId)));
        Lists.difference(rightList, leftList, equalsFunction).forEach(valueOrId -> changes.add(new ValueAdded(valueOrId)));
        return changes;
    }
}

