/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class JaversCoreProperties {
    private String algorithm = "simple";
    private String commitIdGenerator = "synchronized_sequence";
    private String mappingStyle = "field";
    private boolean newObjectSnapshot = false;
    private boolean prettyPrint = true;
    private boolean typeSafeValues = false;
    private String packagesToScan = "";
    private PrettyPrintDateFormats prettyPrintDateFormats = new PrettyPrintDateFormats();

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getCommitIdGenerator() {
        return this.commitIdGenerator;
    }

    public String getMappingStyle() {
        return this.mappingStyle;
    }

    public boolean isNewObjectSnapshot() {
        return this.newObjectSnapshot;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public boolean isTypeSafeValues() {
        return this.typeSafeValues;
    }

    public String getPackagesToScan() {
        return this.packagesToScan;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public void setCommitIdGenerator(String commitIdGenerator) {
        this.commitIdGenerator = commitIdGenerator;
    }

    public void setMappingStyle(String mappingStyle) {
        this.mappingStyle = mappingStyle;
    }

    public void setNewObjectSnapshot(boolean newObjectSnapshot) {
        this.newObjectSnapshot = newObjectSnapshot;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public void setTypeSafeValues(boolean typeSafeValues) {
        this.typeSafeValues = typeSafeValues;
    }

    public void setPackagesToScan(String packagesToScan) {
        this.packagesToScan = packagesToScan;
    }

    public PrettyPrintDateFormats getPrettyPrintDateFormats() {
        return this.prettyPrintDateFormats;
    }

    public static class PrettyPrintDateFormats {
        private Map<Class<? extends Temporal>, String> formats = new HashMap<Class<? extends Temporal>, String>();
        private static final String DEFAULT_DATE_FORMAT = "dd MMM yyyy";
        private static final String DEFAULT_TIME_FORMAT = "HH:mm:ss";

        public PrettyPrintDateFormats() {
            this.setLocalDateTime("dd MMM yyyy, HH:mm:ss");
            this.setZonedDateTime("dd MMM yyyy, HH:mm:ssZ");
            this.setLocalDate(DEFAULT_DATE_FORMAT);
            this.setLocalTime(DEFAULT_TIME_FORMAT);
        }

        public void registerFormat(Class<? extends Temporal> forType, String format) {
            this.formats.put(forType, format);
        }

        public void setLocalDateTime(String localDateTime) {
            this.registerFormat(LocalDateTime.class, localDateTime);
        }

        public void setZonedDateTime(String zonedDateTime) {
            this.registerFormat(ZonedDateTime.class, zonedDateTime);
        }

        public void setLocalDate(String localDate) {
            this.registerFormat(LocalDate.class, localDate);
        }

        public void setLocalTime(String localTime) {
            this.registerFormat(LocalTime.class, localTime);
        }

        public String getLocalDateTime() {
            return this.formats.get(LocalDateTime.class);
        }

        public String getZonedDateTime() {
            return this.formats.get(ZonedDateTime.class);
        }

        public String getLocalDate() {
            return this.formats.get(LocalDate.class);
        }

        public String getLocalTime() {
            return this.formats.get(LocalTime.class);
        }

        public Map<Class<? extends Temporal>, String> getFormats() {
            return Collections.unmodifiableMap(this.formats);
        }
    }
}

