/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.appenders;

import java.util.List;
import java.util.Map;
import org.javers.common.collections.Arrays;
import org.javers.common.collections.Lists;
import org.javers.core.diff.NodePair;
import org.javers.core.diff.appenders.MapChangeAppender;
import org.javers.core.diff.appenders.MapChangesToListChangesFunction;
import org.javers.core.diff.appenders.PropertyChangeAppender;
import org.javers.core.diff.changetype.container.ArrayChange;
import org.javers.core.diff.changetype.container.ContainerElementChange;
import org.javers.core.diff.changetype.map.EntryChange;
import org.javers.core.metamodel.type.ArrayType;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.MapContentType;
import org.javers.core.metamodel.type.TypeMapper;

class ArrayChangeAppender
implements PropertyChangeAppender<ArrayChange> {
    private final MapChangeAppender mapChangeAppender;
    private final TypeMapper typeMapper;

    ArrayChangeAppender(MapChangeAppender mapChangeAppender, TypeMapper typeMapper) {
        this.mapChangeAppender = mapChangeAppender;
        this.typeMapper = typeMapper;
    }

    @Override
    public boolean supports(JaversType propertyType) {
        return propertyType instanceof ArrayType;
    }

    @Override
    public ArrayChange calculateChanges(NodePair pair, JaversProperty property) {
        ArrayType arrayType;
        MapContentType mapContentType;
        Map rightMap;
        Map leftMap = Arrays.asMap(pair.getLeftDehydratedPropertyValueAndSanitize(property));
        List<EntryChange> entryChanges = this.mapChangeAppender.calculateEntryChanges(leftMap, rightMap = Arrays.asMap(pair.getRightDehydratedPropertyValueAndSanitize(property)), mapContentType = this.typeMapper.getMapContentType(arrayType = (ArrayType)property.getType()));
        if (!entryChanges.isEmpty()) {
            List<ContainerElementChange> elementChanges = Lists.transform(entryChanges, new MapChangesToListChangesFunction());
            return new ArrayChange(pair.createPropertyChangeMetadata(property), elementChanges);
        }
        return null;
    }
}

