/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.stream.Collectors;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.InstanceId;
import org.javers.core.metamodel.type.EntityType;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.PrimitiveOrValueType;
import org.javers.core.metamodel.type.ValueObjectType;

class InstanceIdFactory {
    private final EntityType entityType;

    InstanceIdFactory(EntityType entityType) {
        this.entityType = entityType;
    }

    InstanceId create(Object localId) {
        Validate.argumentsAreNotNull(this.entityType, localId);
        Object dehydratedLocalId = this.dehydratedLocalId(this.entityType, localId);
        String localIdAsString = this.localIdAsString(dehydratedLocalId);
        return new InstanceId(this.entityType.getName(), dehydratedLocalId, localIdAsString);
    }

    InstanceId createFromDehydratedLocalId(Object dehydratedLocalId) {
        Validate.argumentsAreNotNull(this.entityType, dehydratedLocalId);
        String localIdAsString = this.localIdAsString(dehydratedLocalId);
        return new InstanceId(this.entityType.getName(), dehydratedLocalId, localIdAsString);
    }

    String localIdAsString(Object dehydratedLocalId) {
        if (dehydratedLocalId instanceof String) {
            return (String)dehydratedLocalId;
        }
        return this.localIdAsString(this.entityType.getIdProperty(), dehydratedLocalId);
    }

    private Object dehydratedLocalId(EntityType entityType, Object localId) {
        if (entityType.hasCompositeId()) {
            Map compositeLocalId = (Map)localId;
            return String.join((CharSequence)",", compositeLocalId.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> this.localIdAsString(entityType.getProperty((String)e.getKey()), e.getValue())).collect(Collectors.toList()));
        }
        return this.dehydratedLocalId(entityType.getIdProperty(), localId);
    }

    String localIdAsString(JaversProperty idProperty, Object dehydratedAtomicLocalId) {
        if (idProperty.isEntityType()) {
            EntityType idPropertyType = (EntityType)idProperty.getType();
            return idPropertyType.getInstanceIdFactory().localIdAsString(dehydratedAtomicLocalId);
        }
        if (idProperty.isValueObjectType()) {
            return dehydratedAtomicLocalId.toString();
        }
        if (idProperty.isPrimitiveOrValueType()) {
            PrimitiveOrValueType primitiveOrValueType = (PrimitiveOrValueType)idProperty.getType();
            return primitiveOrValueType.smartToString(dehydratedAtomicLocalId);
        }
        throw this.idTypeNotSupported();
    }

    private JaversException idTypeNotSupported() {
        return new JaversException(JaversExceptionCode.ID_TYPE_NOT_SUPPORTED, ((JaversType)this.entityType.getIdProperty().getType()).getName(), this.entityType.getBaseJavaClass().getName());
    }

    Type getLocalIdDehydratedType() {
        if (this.entityType.hasCompositeId()) {
            return String.class;
        }
        JaversProperty idProperty = this.entityType.getIdProperty();
        if (idProperty.isEntityType()) {
            EntityType idPropertyType = (EntityType)idProperty.getType();
            return idPropertyType.getLocalIdDehydratedType();
        }
        if (idProperty.isValueObjectType()) {
            return String.class;
        }
        if (idProperty.isPrimitiveOrValueType()) {
            return idProperty.getGenericType();
        }
        throw this.idTypeNotSupported();
    }

    private Object dehydratedLocalId(JaversProperty idProperty, Object localId) {
        if (idProperty.isEntityType()) {
            EntityType idPropertyType = (EntityType)idProperty.getType();
            return idPropertyType.getIdOf(localId);
        }
        if (idProperty.isValueObjectType()) {
            ValueObjectType valueObjectType = (ValueObjectType)idProperty.getType();
            return valueObjectType.smartToString(localId);
        }
        if (idProperty.isPrimitiveOrValueType()) {
            return localId;
        }
        throw this.idTypeNotSupported();
    }
}

