/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.object;

import java.io.Serializable;
import java.util.Comparator;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.type.ManagedType;

public abstract class GlobalId
implements Serializable,
Comparable<GlobalId> {
    private final String typeName;

    GlobalId(String typeName) {
        Validate.argumentIsNotNull(typeName);
        this.typeName = typeName;
    }

    public abstract String value();

    public String toString() {
        return this.value();
    }

    public boolean isTypeOf(ManagedType managedType) {
        return this.getTypeName().equals(managedType.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GlobalId)) {
            return false;
        }
        return this.value().equals(((GlobalId)o).value());
    }

    public int hashCode() {
        return this.value().hashCode();
    }

    public String getTypeName() {
        return this.typeName;
    }

    public GlobalId masterObjectId() {
        return this;
    }

    String getTypeNameShort() {
        String[] split = this.getTypeName().split("\\.");
        if (split.length >= 2) {
            return "..." + split[split.length - 1];
        }
        return this.getTypeName();
    }

    @Override
    public int compareTo(GlobalId o) {
        return Comparator.comparing(GlobalId::value).compare(this, o);
    }
}

