/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.clazz;

import java.util.ArrayList;
import java.util.List;
import org.javers.common.collections.Arrays;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.clazz.ClientsClassDefinitionBuilder;
import org.javers.core.metamodel.clazz.EntityDefinition;

public class EntityDefinitionBuilder
extends ClientsClassDefinitionBuilder<EntityDefinitionBuilder> {
    private List<String> idPropertyNames = new ArrayList<String>();
    private boolean shallowReference;

    EntityDefinitionBuilder(Class<?> entity) {
        super(entity);
    }

    public static EntityDefinitionBuilder entityDefinition(Class<?> entity) {
        return new EntityDefinitionBuilder(entity);
    }

    public EntityDefinitionBuilder withIdPropertyName(String idPropertyName) {
        Validate.argumentIsNotNull(idPropertyName);
        if (!this.idPropertyNames.contains(idPropertyName)) {
            this.idPropertyNames.add(idPropertyName);
        }
        return this;
    }

    public EntityDefinitionBuilder withIdPropertyNames(String ... idPropertyNames) {
        Validate.argumentIsNotNull(idPropertyNames);
        return this.withIdPropertyNames(Arrays.asList(idPropertyNames));
    }

    public EntityDefinitionBuilder withIdPropertyNames(List<String> idPropertyNames) {
        Validate.argumentIsNotNull(idPropertyNames);
        idPropertyNames.forEach(this::withIdPropertyName);
        return this;
    }

    public EntityDefinitionBuilder withShallowReference() {
        this.shallowReference = true;
        return this;
    }

    @Override
    public EntityDefinition build() {
        return new EntityDefinition(this);
    }

    List<String> getIdPropertyNames() {
        return this.idPropertyNames;
    }

    boolean isShallowReference() {
        return this.shallowReference;
    }
}

