/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.changetype.container;

import java.util.Objects;
import org.javers.common.string.PrettyValuePrinter;
import org.javers.core.diff.changetype.Atomic;
import org.javers.core.diff.changetype.container.ContainerElementChange;

public class ElementValueChange
extends ContainerElementChange {
    private final Atomic leftValue;
    private final Atomic rightValue;

    public ElementValueChange(int index, Object leftValue, Object rightValue) {
        super(index);
        this.leftValue = new Atomic(leftValue);
        this.rightValue = new Atomic(rightValue);
    }

    public Object getLeftValue() {
        return this.leftValue.unwrap();
    }

    public Object getRightValue() {
        return this.rightValue.unwrap();
    }

    public String toString() {
        return this.prettyPrint(PrettyValuePrinter.getDefault());
    }

    @Override
    protected String prettyPrint(PrettyValuePrinter valuePrinter) {
        return this.getIndex() + ". " + valuePrinter.formatWithQuotes(this.getLeftValue()) + " changed to " + valuePrinter.formatWithQuotes(this.getRightValue());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ElementValueChange) {
            ElementValueChange that = (ElementValueChange)obj;
            return super.equals(that) && Objects.equals(this.getLeftValue(), that.getLeftValue()) && Objects.equals(this.getRightValue(), that.getRightValue());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getLeftValue(), this.getRightValue());
    }
}

