/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.changetype.container;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.javers.common.collections.Lists;
import org.javers.common.string.PrettyValuePrinter;
import org.javers.common.validation.Validate;
import org.javers.core.diff.changetype.PropertyChange;
import org.javers.core.diff.changetype.PropertyChangeMetadata;
import org.javers.core.diff.changetype.container.ContainerElementChange;
import org.javers.core.diff.changetype.container.ValueAdded;
import org.javers.core.diff.changetype.container.ValueRemoved;

public abstract class ContainerChange
extends PropertyChange {
    private final List<ContainerElementChange> changes;

    ContainerChange(PropertyChangeMetadata metadata, List<ContainerElementChange> changes) {
        super(metadata);
        Validate.argumentIsNotNull(changes);
        Validate.argumentCheck(!changes.isEmpty(), "changes list should not be empty");
        this.changes = Collections.unmodifiableList(new ArrayList<ContainerElementChange>(changes));
    }

    public List<ContainerElementChange> getChanges() {
        return this.changes;
    }

    public List<ValueAdded> getValueAddedChanges() {
        return Lists.positiveFilter(this.changes, input -> input instanceof ValueAdded);
    }

    public List<ValueRemoved> getValueRemovedChanges() {
        return Lists.positiveFilter(this.changes, input -> input instanceof ValueRemoved);
    }

    public List<?> getAddedValues() {
        return Lists.transform(this.getValueAddedChanges(), input -> input.getAddedValue());
    }

    public List<?> getRemovedValues() {
        return Lists.transform(this.getValueRemovedChanges(), input -> input.getRemovedValue());
    }

    @Override
    public String prettyPrint(PrettyValuePrinter valuePrinter) {
        Validate.argumentIsNotNull(valuePrinter);
        StringBuilder builder = new StringBuilder();
        builder.append(valuePrinter.formatWithQuotes(this.getPropertyNameWithPath()) + " collection changes :\n");
        this.changes.forEach(cc -> builder.append("  " + cc.prettyPrint(valuePrinter) + "\n"));
        String result = builder.toString();
        return result.substring(0, result.length() - 1);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ContainerChange) {
            ContainerChange that = (ContainerChange)obj;
            return super.equals(that) && Objects.equals(this.changes, that.changes);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.changes);
    }
}

