/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.appenders.levenshtein;

import java.util.List;
import org.javers.common.validation.Validate;
import org.javers.core.diff.EqualsFunction;
import org.javers.core.diff.appenders.CorePropertyChangeAppender;
import org.javers.core.diff.appenders.levenshtein.Backtrack;
import org.javers.core.diff.appenders.levenshtein.BacktrackSteps;
import org.javers.core.diff.appenders.levenshtein.StepsToChanges;
import org.javers.core.diff.changetype.container.ContainerElementChange;
import org.javers.core.diff.changetype.container.ListChange;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.CollectionType;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ListType;
import org.javers.core.metamodel.type.TypeMapper;

public class LevenshteinListChangeAppender
extends CorePropertyChangeAppender<ListChange> {
    private final TypeMapper typeMapper;

    LevenshteinListChangeAppender(TypeMapper typeMapper) {
        Validate.argumentsAreNotNull(typeMapper);
        this.typeMapper = typeMapper;
    }

    @Override
    public boolean supports(JaversType propertyType) {
        return propertyType instanceof ListType;
    }

    @Override
    public ListChange calculateChanges(Object leftValue, Object rightValue, GlobalId affectedId, JaversProperty property) {
        CollectionType listType = (CollectionType)property.getType();
        JaversType itemType = this.typeMapper.getJaversType(listType.getItemType());
        List leftList = (List)leftValue;
        List rightList = (List)rightValue;
        EqualsFunction equalsFunction = itemType::equals;
        StepsToChanges stepsToChanges = new StepsToChanges(equalsFunction);
        Backtrack backtrack = new Backtrack(equalsFunction);
        BacktrackSteps[][] steps = backtrack.evaluateSteps(leftList, rightList);
        List<ContainerElementChange> changes = stepsToChanges.convert(steps, leftList, rightList);
        ListChange result = this.getListChange(affectedId, property, changes);
        if (result != null) {
            LevenshteinListChangeAppender.renderNotParametrizedWarningIfNeeded(listType.getItemType(), "item", "List", property);
        }
        return result;
    }

    private ListChange getListChange(GlobalId affectedCdoId, Property property, List<ContainerElementChange> changes) {
        ListChange result = changes.size() == 0 ? null : new ListChange(affectedCdoId, property.getName(), changes);
        return result;
    }
}

