/*
 * Decompiled with CFR 0.152.
 */
package org.javers.common.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.reflection.JaversMember;

public class JaversField
extends JaversMember<Field> {
    protected JaversField(Field rawField, Type resolvedReturnType) {
        super(rawField, resolvedReturnType);
    }

    @Override
    protected Type getRawGenericType() {
        return ((Field)this.getRawMember()).getGenericType();
    }

    @Override
    public Class<?> getRawType() {
        return ((Field)this.getRawMember()).getType();
    }

    @Override
    public Object getEvenIfPrivate(Object onObject) {
        try {
            return ((Field)this.getRawMember()).get(onObject);
        }
        catch (IllegalArgumentException ie) {
            throw new JaversException(JaversExceptionCode.MISSING_PROPERTY, this, ie.getClass().getName());
        }
        catch (IllegalAccessException e) {
            throw new JaversException(JaversExceptionCode.PROPERTY_ACCESS_ERROR, this, onObject.getClass().getSimpleName(), e.getClass().getName() + ": " + e.getMessage());
        }
    }

    @Override
    public void setEvenIfPrivate(Object onObject, Object value) {
        try {
            ((Field)this.getRawMember()).set(onObject, value);
        }
        catch (IllegalArgumentException ie) {
            String valueType = value == null ? "null" : value.getClass().getName();
            throw new JaversException(JaversExceptionCode.PROPERTY_SETTING_ERROR, valueType, this, ie.getClass().getName() + " - " + ie.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new JaversException(JaversExceptionCode.PROPERTY_ACCESS_ERROR, this, onObject.getClass().getSimpleName(), e.getClass().getName() + ": " + e.getMessage());
        }
    }

    @Override
    public String memberType() {
        return "Field";
    }
}

