/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Type;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.InstanceId;
import org.javers.core.metamodel.type.EntityType;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.PrimitiveOrValueType;
import org.javers.core.metamodel.type.ValueObjectType;

class InstanceIdFactory {
    private final EntityType entityType;

    InstanceIdFactory(EntityType entityType) {
        this.entityType = entityType;
    }

    InstanceId create(Object localId) {
        Validate.argumentsAreNotNull(this.entityType, localId);
        Object dehydratedLocalId = this.dehydratedLocalId(this.entityType, localId);
        String localIdAsString = this.localIdAsString(dehydratedLocalId);
        return new InstanceId(this.entityType.getName(), dehydratedLocalId, localIdAsString);
    }

    InstanceId createFromDehydratedLocalId(Object dehydratedLocalId) {
        Validate.argumentsAreNotNull(this.entityType, dehydratedLocalId);
        String localIdAsString = this.localIdAsString(dehydratedLocalId);
        return new InstanceId(this.entityType.getName(), dehydratedLocalId, localIdAsString);
    }

    String localIdAsString(Object dehydratedLocalId) {
        if (this.isIdEntity()) {
            EntityType idPropertyType = (EntityType)this.entityType.getIdPropertyType();
            return idPropertyType.getInstanceIdFactory().localIdAsString(dehydratedLocalId);
        }
        if (this.isIdValueObject()) {
            return dehydratedLocalId.toString();
        }
        if (this.isIdPrimitiveOrValue()) {
            PrimitiveOrValueType primitiveOrValueType = (PrimitiveOrValueType)this.entityType.getIdProperty().getType();
            return primitiveOrValueType.smartToString(dehydratedLocalId);
        }
        throw this.idTypeNotSupported();
    }

    private JaversException idTypeNotSupported() {
        return new JaversException(JaversExceptionCode.ID_TYPE_NOT_SUPPORTED, ((JaversType)this.entityType.getIdProperty().getType()).getName(), this.entityType.getBaseJavaClass().getName());
    }

    Type getLocalIdDehydratedType() {
        if (this.isIdEntity()) {
            EntityType idPropertyType = (EntityType)this.entityType.getIdPropertyType();
            return idPropertyType.getIdPropertyGenericType();
        }
        if (this.isIdValueObject()) {
            return String.class;
        }
        if (this.isIdPrimitiveOrValue()) {
            return this.entityType.getIdPropertyGenericType();
        }
        throw this.idTypeNotSupported();
    }

    private Object dehydratedLocalId(EntityType entityType, Object localId) {
        if (this.isIdEntity()) {
            EntityType idPropertyType = (EntityType)entityType.getIdPropertyType();
            return idPropertyType.getIdOf(localId);
        }
        if (this.isIdValueObject()) {
            ValueObjectType valueObjectType = (ValueObjectType)entityType.getIdPropertyType();
            return valueObjectType.smartToString(localId);
        }
        if (this.isIdPrimitiveOrValue()) {
            return localId;
        }
        throw this.idTypeNotSupported();
    }

    private boolean isIdEntity() {
        return this.entityType.getIdProperty().getType() instanceof EntityType;
    }

    private boolean isIdValueObject() {
        return this.entityType.getIdProperty().getType() instanceof ValueObjectType;
    }

    private boolean isIdPrimitiveOrValue() {
        return this.entityType.getIdProperty().getType() instanceof PrimitiveOrValueType;
    }
}

