/*
 * Decompiled with CFR 0.152.
 */
package org.javers.common.reflection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Optional;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.reflection.JaversMember;
import org.javers.common.string.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaversGetter
extends JaversMember<Method> {
    private static final Logger logger = LoggerFactory.getLogger(JaversGetter.class);
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private final Optional<Method> setterMethod;

    protected JaversGetter(Method getterMethod, Type resolvedReturnType) {
        super(getterMethod, resolvedReturnType);
        this.setterMethod = this.findSetterForGetter(getterMethod);
    }

    protected JaversGetter(Method getterMethod, Type resolvedReturnType, boolean looksLikeId) {
        super(getterMethod, resolvedReturnType, looksLikeId);
        this.setterMethod = this.findSetterForGetter(getterMethod);
    }

    @Override
    protected Type getRawGenericType() {
        return ((Method)this.getRawMember()).getGenericReturnType();
    }

    @Override
    public Class<?> getRawType() {
        return ((Method)this.getRawMember()).getReturnType();
    }

    @Override
    public Object getEvenIfPrivate(Object onObject) {
        try {
            return ((Method)this.getRawMember()).invoke(onObject, EMPTY_ARRAY);
        }
        catch (IllegalArgumentException ie) {
            throw new JaversException(JaversExceptionCode.MISSING_PROPERTY, this, ie.getClass().getName());
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new JaversException(JaversExceptionCode.PROPERTY_ACCESS_ERROR, this, onObject.getClass().getSimpleName(), e.getClass().getName() + ": " + e.getMessage());
        }
    }

    @Override
    public void setEvenIfPrivate(Object onObject, Object value) {
        this.setterMethod.orElseThrow(() -> new JaversException(JaversExceptionCode.SETTER_NOT_FOUND, ((Method)this.getRawMember()).getName(), ((Method)this.getRawMember()).getDeclaringClass().getName()));
        try {
            this.setterMethod.get().invoke(onObject, value);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new JaversException(JaversExceptionCode.SETTER_INVOCATION_ERROR, this.setterMethod.get().getName(), onObject.getClass().getName(), e);
        }
    }

    @Override
    public String propertyName() {
        return this.getterNameToFieldName(this.name());
    }

    public String toString() {
        return "Getter " + ToStringBuilder.typeName(this.getGenericResolvedType()) + " " + this.name() + ", declared in " + this.getDeclaringClass().getSimpleName();
    }

    private Optional<Method> findSetterForGetter(Method getter) {
        Class<?> clazz = getter.getDeclaringClass();
        String setterName = JaversGetter.setterNameForGetterName(getter.getName());
        try {
            Method setter = clazz.getDeclaredMethod(setterName, getter.getReturnType());
            this.setAccessibleIfNecessary(setter);
            return Optional.of(setter);
        }
        catch (NoSuchMethodException e) {
            logger.debug("setter for getter '" + clazz.getName() + "." + getter.getName() + " not found");
            return Optional.empty();
        }
    }

    private String getterNameToFieldName(String getterName) {
        String withoutPrefix = JaversGetter.getterNameWithoutPrefix(getterName);
        return withoutPrefix.substring(0, 1).toLowerCase() + withoutPrefix.substring(1);
    }

    private static String setterNameForGetterName(String getterName) {
        return "set" + JaversGetter.getterNameWithoutPrefix(getterName);
    }

    private static String getterNameWithoutPrefix(String getterName) {
        if (getterName.substring(0, 3).equals("get")) {
            return getterName.substring(3);
        }
        if (getterName.substring(0, 2).equals("is")) {
            return getterName.substring(2);
        }
        throw new IllegalArgumentException("Name {" + getterName + "} is not a getter name");
    }
}

