/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.graph;

import org.javers.common.collections.EnumerableFunction;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.core.graph.AbstractSingleEdge;
import org.javers.core.graph.LiveCdo;
import org.javers.core.graph.LiveCdoFactory;
import org.javers.core.graph.LiveNode;
import org.javers.core.graph.MultiEdge;
import org.javers.core.graph.NodeReuser;
import org.javers.core.graph.ObjectNode;
import org.javers.core.graph.ShallowSingleEdge;
import org.javers.core.graph.SingleEdge;
import org.javers.core.metamodel.object.EnumerationAwareOwnerContext;
import org.javers.core.metamodel.object.OwnerContext;
import org.javers.core.metamodel.object.PropertyOwnerContext;
import org.javers.core.metamodel.type.ContainerType;
import org.javers.core.metamodel.type.EnumerableType;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.KeyValueType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.MapEnumerationOwnerContext;
import org.javers.core.metamodel.type.TypeMapper;

class EdgeBuilder {
    private final TypeMapper typeMapper;
    private final NodeReuser nodeReuser;
    private final LiveCdoFactory cdoFactory;

    EdgeBuilder(TypeMapper typeMapper, NodeReuser nodeReuser, LiveCdoFactory cdoFactory) {
        this.typeMapper = typeMapper;
        this.nodeReuser = nodeReuser;
        this.cdoFactory = cdoFactory;
    }

    AbstractSingleEdge buildSingleEdge(ObjectNode node, JaversProperty singleRef) {
        Object rawReference = node.getPropertyValue(singleRef);
        LiveCdo cdo = this.cdoFactory.create(rawReference, this.createOwnerContext(node, singleRef));
        if (!singleRef.isShallowReference()) {
            LiveNode targetNode = this.buildNodeStubOrReuse(cdo);
            return new SingleEdge(singleRef, targetNode);
        }
        return new ShallowSingleEdge(singleRef, cdo);
    }

    private OwnerContext createOwnerContext(ObjectNode parentNode, JaversProperty property) {
        return new PropertyOwnerContext(parentNode.getGlobalId(), property.getName());
    }

    MultiEdge createMultiEdge(JaversProperty containerProperty, EnumerableType enumerableType, ObjectNode node) {
        MultiEdgeMapBuilder edgeBuilder;
        OwnerContext owner = this.createOwnerContext(node, containerProperty);
        Object container = node.getPropertyValue(containerProperty);
        if (enumerableType instanceof KeyValueType) {
            KeyValueType mapType = (KeyValueType)enumerableType;
            edgeBuilder = new MultiEdgeMapBuilder(this.typeMapper.getJaversType(mapType.getKeyType()) instanceof ManagedType, this.typeMapper.getJaversType(mapType.getValueType()) instanceof ManagedType);
        } else if (enumerableType instanceof ContainerType) {
            edgeBuilder = (input, context) -> this.buildNodeStubOrReuse(this.cdoFactory.create(input, context));
        } else {
            throw new JaversException(JaversExceptionCode.NOT_IMPLEMENTED, new Object[0]);
        }
        Object nodesEnumerable = enumerableType.map(container, edgeBuilder, owner);
        return new MultiEdge(containerProperty, nodesEnumerable);
    }

    private LiveNode buildNodeStubOrReuse(LiveCdo cdo) {
        if (this.nodeReuser.isReusable(cdo)) {
            return this.nodeReuser.getForReuse(cdo);
        }
        return this.buildNodeStub(cdo);
    }

    LiveNode buildNodeStub(LiveCdo cdo) {
        LiveNode newStub = new LiveNode(cdo);
        this.nodeReuser.enqueueStub(newStub);
        return newStub;
    }

    private class MultiEdgeMapBuilder
    implements EnumerableFunction {
        private final boolean managedKeys;
        private final boolean managedValues;

        public MultiEdgeMapBuilder(boolean managedKeys, boolean managedValues) {
            this.managedKeys = managedKeys;
            this.managedValues = managedValues;
        }

        public Object apply(Object keyOrValue, EnumerationAwareOwnerContext context) {
            MapEnumerationOwnerContext mapContext = (MapEnumerationOwnerContext)context;
            if (this.managedKeys && mapContext.isKey()) {
                LiveNode objectNode = EdgeBuilder.this.buildNodeStubOrReuse(EdgeBuilder.this.cdoFactory.create(keyOrValue, context));
                return objectNode;
            }
            if (this.managedValues && !mapContext.isKey()) {
                LiveNode objectNode = EdgeBuilder.this.buildNodeStubOrReuse(EdgeBuilder.this.cdoFactory.create(keyOrValue, context));
                return objectNode;
            }
            return keyOrValue;
        }
    }
}

