/*
 * Decompiled with CFR 0.152.
 */
package org.javers.common.reflection;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.javers.common.reflection.JaversGetter;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.common.reflection.TypeResolvingContext;

class JaversGetterFactory {
    private final Class getterSource;
    private final List<JaversGetter> getters = new ArrayList<JaversGetter>();
    private final TypeResolvingContext context = new TypeResolvingContext();

    JaversGetterFactory(Class getterSource) {
        this.getterSource = getterSource;
    }

    List<JaversGetter> getAllGetters() {
        if (this.getters.size() > 0) {
            throw new IllegalStateException("getters.size() > 0");
        }
        this.findAllGetters(this.getterSource);
        return this.getters;
    }

    private void findAllGetters(Class currentGetterSource) {
        Class clazz;
        for (clazz = currentGetterSource; clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            this.context.addTypeSubstitutions(clazz);
            Arrays.stream(clazz.getDeclaredMethods()).filter(method -> JaversGetterFactory.isGetter(method) && !method.isBridge()).filter(method -> !JaversGetterFactory.isOverridden(method, this.getters)).map(getter -> this.createJaversGetter((Method)getter, this.context)).filter(getter -> this.excludeDuplicatedProperties((JaversGetter)getter, this.getters)).forEach(this.getters::add);
        }
        for (clazz = currentGetterSource; clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            Arrays.stream(clazz.getInterfaces()).forEach(this::findAllGetters);
        }
    }

    private boolean excludeDuplicatedProperties(JaversGetter getter, List<JaversGetter> getters) {
        String propertyName = getter.propertyName();
        return getters.stream().map(JaversGetter::propertyName).noneMatch(propertyName::equals);
    }

    private static boolean isGetter(Method rawMethod) {
        return JaversGetterFactory.hasGetOrIsPrefix(rawMethod) && JaversGetterFactory.hasNoParamters(rawMethod) && JaversGetterFactory.returnsSomething(rawMethod) && JaversGetterFactory.isNotStatic(rawMethod) && JaversGetterFactory.isNotNative(rawMethod);
    }

    private static boolean hasGetOrIsPrefix(Method rawMethod) {
        return rawMethod.getName().startsWith("get") || rawMethod.getName().startsWith("is");
    }

    private static boolean hasNoParamters(Method rawMethod) {
        return rawMethod.getParameterTypes().length == 0;
    }

    private static boolean returnsSomething(Method rawMethod) {
        return rawMethod.getGenericReturnType() != Void.TYPE;
    }

    private static boolean isNotStatic(Method rawMethod) {
        return !Modifier.isStatic(rawMethod.getModifiers());
    }

    private static boolean isNotNative(Method rawMethod) {
        return !Modifier.isNative(rawMethod.getModifiers());
    }

    private static boolean isOverridden(Method parent, Collection<JaversGetter> toCheck) {
        return toCheck.stream().map(it -> (Method)it.getRawMember()).anyMatch(it -> JaversGetterFactory.isOverridden(parent, it));
    }

    private static boolean isOverridden(Method parent, Method toCheck) {
        return JaversGetterFactory.isSubClass(parent, toCheck) && JaversGetterFactory.sameMethodName(parent, toCheck) && JaversGetterFactory.returnTypeCovariant(parent, toCheck) && JaversGetterFactory.sameArguments(parent, toCheck);
    }

    private static boolean isSubClass(Method parent, Method toCheck) {
        return parent.getDeclaringClass().isAssignableFrom(toCheck.getDeclaringClass());
    }

    private static boolean sameMethodName(Method parent, Method toCheck) {
        return parent.getName().equals(toCheck.getName());
    }

    private static boolean returnTypeCovariant(Method parent, Method toCheck) {
        return parent.getReturnType().isAssignableFrom(toCheck.getReturnType());
    }

    private static boolean sameArguments(Method parent, Method toCheck) {
        return Arrays.equals(parent.getParameterTypes(), toCheck.getParameterTypes());
    }

    private JaversGetter createJaversGetter(Method getterMethod, TypeResolvingContext context) {
        Type actualReturnType = context.getSubstitution(getterMethod.getGenericReturnType());
        if (JaversGetterFactory.hasInheritedId(getterMethod)) {
            return new JaversGetter(getterMethod, actualReturnType, true);
        }
        return new JaversGetter(getterMethod, actualReturnType);
    }

    private static boolean hasInheritedId(Method concrete) {
        ArrayList overridden = new ArrayList();
        for (Class<?> clazz = concrete.getDeclaringClass().getSuperclass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            Arrays.asList(clazz.getDeclaredMethods()).stream().filter(parent -> JaversGetterFactory.isOverridden(parent, concrete)).findFirst().ifPresent(parent -> overridden.add(parent));
        }
        return overridden.stream().anyMatch(ReflectionUtil::looksLikeId);
    }
}

