/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.javers.common.validation.Validate;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.diff.NodePair;
import org.javers.core.diff.changetype.PropertyChangeType;
import org.javers.core.graph.ObjectNode;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.property.MissingProperty;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.ManagedType;

public class RealNodePair
implements NodePair {
    private final ObjectNode left;
    private final ObjectNode right;
    private final Optional<CommitMetadata> commitMetadata;

    RealNodePair(ObjectNode left, ObjectNode right) {
        this(left, right, Optional.empty());
    }

    public RealNodePair(ObjectNode left, ObjectNode right, Optional<CommitMetadata> commitMetadata) {
        Validate.argumentsAreNotNull(left, right, commitMetadata);
        Validate.argumentCheck(left.getGlobalId().equals(right.getGlobalId()), "left & right should refer to the same Cdo");
        this.left = left;
        this.right = right;
        this.commitMetadata = commitMetadata;
    }

    @Override
    public ManagedType getManagedType() {
        return this.right.getManagedType();
    }

    @Override
    public boolean isNullOnBothSides(Property property) {
        return this.left.getPropertyValue(property) == null && this.right.getPropertyValue(property) == null;
    }

    @Override
    public Object getLeftPropertyValue(Property property) {
        return this.left.getPropertyValue(property);
    }

    @Override
    public Object getRightPropertyValue(Property property) {
        return this.right.getPropertyValue(property);
    }

    @Override
    public GlobalId getRightReference(Property property) {
        return this.right.getReference(property);
    }

    @Override
    public GlobalId getLeftReference(Property property) {
        return this.left.getReference(property);
    }

    @Override
    public List<GlobalId> getRightReferences(JaversProperty property) {
        return this.right.getReferences(property);
    }

    @Override
    public List<GlobalId> getLeftReferences(JaversProperty property) {
        return this.left.getReferences(property);
    }

    @Override
    public ObjectNode getRight() {
        return this.right;
    }

    @Override
    public ObjectNode getLeft() {
        return this.left;
    }

    boolean sameClass() {
        return this.right.getManagedType().getBaseJavaType() == this.left.getManagedType().getBaseJavaType();
    }

    @Override
    public List<JaversProperty> getProperties() {
        if (this.sameClass()) {
            return this.getManagedType().getProperties();
        }
        return Collections.unmodifiableList(this.getPropertiesFromBothSides());
    }

    private List<JaversProperty> getPropertiesFromBothSides() {
        Set leftNames = this.left.getManagedType().getProperties().stream().map(it -> it.getName()).collect(Collectors.toSet());
        return Stream.concat(this.left.getManagedType().getProperties().stream(), this.right.getManagedType().getProperties().stream().filter(it -> !leftNames.contains(it.getName()))).collect(Collectors.toList());
    }

    @Override
    public GlobalId getGlobalId() {
        return this.left.getGlobalId();
    }

    @Override
    public Optional<CommitMetadata> getCommitMetadata() {
        return this.commitMetadata;
    }

    @Override
    public PropertyChangeType getChangeType(JaversProperty property) {
        if (this.getLeft().getManagedType().getBaseJavaClass() == this.getRight().getManagedType().getBaseJavaClass()) {
            return PropertyChangeType.PROPERTY_VALUE_CHANGED;
        }
        if (this.getLeftPropertyValue(property) == MissingProperty.INSTANCE) {
            return PropertyChangeType.PROPERTY_ADDED;
        }
        if (this.getRightPropertyValue(property) == MissingProperty.INSTANCE) {
            return PropertyChangeType.PROPERTY_REMOVED;
        }
        return PropertyChangeType.PROPERTY_VALUE_CHANGED;
    }
}

