/*
 * Decompiled with CFR 0.152.
 */
package org.javers.common.collections;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.javers.common.collections.Lists;
import org.javers.common.reflection.ReflectionUtil;

public class Primitives {
    private static final List<Class<?>> PRIMITIVE_NUMBER_TYPES = Lists.asList(Integer.TYPE, Long.TYPE, Short.TYPE, Float.TYPE, Double.TYPE, Byte.TYPE);
    private static final List<Class<?>> PRIMITIVE_TYPES = Lists.asList(Boolean.TYPE, Character.TYPE, Integer.class, Long.class, Short.class, Float.class, Double.class, Byte.class, Boolean.class, Character.class);
    private static final List<Class<?>> JSON_BASIC_TYPES = Lists.asList(Integer.TYPE, Integer.class, Double.TYPE, Double.class, Boolean.TYPE, Boolean.class, String.class);

    public static List<Class<?>> getPrimitiveAndBoxTypes() {
        return Collections.unmodifiableList(Stream.concat(PRIMITIVE_NUMBER_TYPES.stream(), PRIMITIVE_TYPES.stream()).collect(Collectors.toList()));
    }

    public static boolean isJsonBasicType(Object object) {
        if (object == null) {
            return false;
        }
        return Primitives.isJsonBasicType(object.getClass());
    }

    public static boolean isPrimitiveNumber(Class<?> clazz) {
        return PRIMITIVE_NUMBER_TYPES.contains(clazz);
    }

    public static boolean isPrimitiveOrBox(Object object) {
        if (object == null) {
            return false;
        }
        return Primitives.isPrimitiveOrBox(object.getClass());
    }

    public static boolean isJsonBasicType(Class clazz) {
        return ReflectionUtil.isAssignableFromAny(clazz, JSON_BASIC_TYPES);
    }

    private static boolean isPrimitiveOrBox(Class clazz) {
        return ReflectionUtil.isAssignableFromAny(clazz, PRIMITIVE_TYPES);
    }
}

