/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core;

import java.util.function.Supplier;
import org.javers.common.string.PrettyValuePrinter;
import org.javers.common.validation.Validate;
import org.javers.core.CommitIdGenerator;
import org.javers.core.JaversCoreProperties;
import org.javers.core.MappingStyle;
import org.javers.core.commit.CommitId;
import org.javers.core.diff.ListCompareAlgorithm;

public class JaversCoreConfiguration {
    private PrettyValuePrinter prettyValuePrinter = PrettyValuePrinter.getDefault();
    private MappingStyle mappingStyle = MappingStyle.FIELD;
    private ListCompareAlgorithm listCompareAlgorithm = ListCompareAlgorithm.SIMPLE;
    private boolean newObjectsSnapshot = false;
    private CommitIdGenerator commitIdGenerator = CommitIdGenerator.SYNCHRONIZED_SEQUENCE;
    private Supplier<CommitId> customCommitIdGenerator;

    JaversCoreConfiguration withMappingStyle(MappingStyle mappingStyle) {
        Validate.argumentIsNotNull((Object)mappingStyle);
        this.mappingStyle = mappingStyle;
        return this;
    }

    JaversCoreConfiguration withCommitIdGenerator(CommitIdGenerator commitIdGenerator) {
        Validate.argumentIsNotNull((Object)commitIdGenerator);
        Validate.argumentCheck(commitIdGenerator != CommitIdGenerator.CUSTOM, "use withCustomCommitIdGenerator(Supplier<CommitId>)");
        this.commitIdGenerator = commitIdGenerator;
        this.customCommitIdGenerator = null;
        return this;
    }

    JaversCoreConfiguration withCustomCommitIdGenerator(Supplier<CommitId> customCommitIdGenerator) {
        Validate.argumentIsNotNull(customCommitIdGenerator);
        this.commitIdGenerator = CommitIdGenerator.CUSTOM;
        this.customCommitIdGenerator = customCommitIdGenerator;
        return this;
    }

    JaversCoreConfiguration withNewObjectsSnapshot(boolean newObjectsSnapshot) {
        this.newObjectsSnapshot = newObjectsSnapshot;
        return this;
    }

    JaversCoreConfiguration withListCompareAlgorithm(ListCompareAlgorithm algorithm) {
        this.listCompareAlgorithm = algorithm;
        return this;
    }

    JaversCoreConfiguration withPrettyPrintDateFormats(JaversCoreProperties.PrettyPrintDateFormats prettyPrintDateFormats) {
        this.prettyValuePrinter = new PrettyValuePrinter(prettyPrintDateFormats);
        return this;
    }

    public PrettyValuePrinter getPrettyValuePrinter() {
        return this.prettyValuePrinter;
    }

    public MappingStyle getMappingStyle() {
        return this.mappingStyle;
    }

    public ListCompareAlgorithm getListCompareAlgorithm() {
        return this.listCompareAlgorithm;
    }

    public boolean isNewObjectsSnapshot() {
        return this.newObjectsSnapshot;
    }

    public CommitIdGenerator getCommitIdGenerator() {
        return this.commitIdGenerator;
    }

    public Supplier<CommitId> getCustomCommitIdGenerator() {
        return this.customCommitIdGenerator;
    }
}

