/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.changetype;

import java.util.Objects;
import org.javers.common.string.PrettyValuePrinter;
import org.javers.common.validation.Validate;
import org.javers.core.diff.changetype.Atomic;
import org.javers.core.diff.changetype.PropertyChange;
import org.javers.core.diff.changetype.PropertyChangeMetadata;

public class ValueChange
extends PropertyChange {
    private final Atomic left;
    private final Atomic right;

    public ValueChange(PropertyChangeMetadata metadata, Object leftValue, Object rightValue) {
        super(metadata);
        this.left = new Atomic(leftValue);
        this.right = new Atomic(rightValue);
    }

    public Object getLeft() {
        return this.left.unwrap();
    }

    public Object getRight() {
        return this.right.unwrap();
    }

    @Override
    public String prettyPrint(PrettyValuePrinter valuePrinter) {
        Validate.argumentIsNotNull(valuePrinter);
        if (this.isPropertyAdded()) {
            return valuePrinter.formatWithQuotes(this.getPropertyNameWithPath()) + " property with value " + valuePrinter.formatWithQuotes(this.right.unwrap()) + " added";
        }
        if (this.isPropertyRemoved()) {
            return valuePrinter.formatWithQuotes(this.getPropertyNameWithPath()) + " property with value " + valuePrinter.formatWithQuotes(this.left.unwrap()) + " removed";
        }
        return valuePrinter.formatWithQuotes(this.getPropertyNameWithPath()) + " value changed from " + valuePrinter.formatWithQuotes(this.left.unwrap()) + " to " + valuePrinter.formatWithQuotes(this.right.unwrap());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ValueChange) {
            ValueChange that = (ValueChange)obj;
            return super.equals(that) && Objects.equals(this.getLeft(), that.getLeft()) && Objects.equals(this.getRight(), that.getRight());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getLeft(), this.getRight());
    }
}

