/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.commit;

import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.core.CommitIdGenerator;
import org.javers.core.JaversCoreConfiguration;
import org.javers.core.commit.CommitId;
import org.javers.core.commit.CommitSeqGenerator;
import org.javers.core.commit.DistributedCommitSeqGenerator;
import org.javers.repository.api.JaversExtendedRepository;

class CommitIdFactory {
    private final JaversCoreConfiguration javersCoreConfiguration;
    private final JaversExtendedRepository javersRepository;
    private final CommitSeqGenerator commitSeqGenerator;
    private final DistributedCommitSeqGenerator distributedCommitSeqGenerator;

    CommitIdFactory(JaversCoreConfiguration javersCoreConfiguration, JaversExtendedRepository javersRepository, CommitSeqGenerator commitSeqGenerator, DistributedCommitSeqGenerator distributedCommitSeqGenerator) {
        this.javersCoreConfiguration = javersCoreConfiguration;
        this.javersRepository = javersRepository;
        this.commitSeqGenerator = commitSeqGenerator;
        this.distributedCommitSeqGenerator = distributedCommitSeqGenerator;
    }

    CommitId nextId() {
        if (this.javersCoreConfiguration.getCommitIdGenerator() == CommitIdGenerator.SYNCHRONIZED_SEQUENCE) {
            CommitId head = this.javersRepository.getHeadId();
            return this.commitSeqGenerator.nextId(head);
        }
        if (this.javersCoreConfiguration.getCommitIdGenerator() == CommitIdGenerator.RANDOM) {
            return this.distributedCommitSeqGenerator.nextId();
        }
        if (this.javersCoreConfiguration.getCommitIdGenerator() == CommitIdGenerator.CUSTOM) {
            return this.javersCoreConfiguration.getCustomCommitIdGenerator().get();
        }
        throw new JaversException(JaversExceptionCode.NOT_IMPLEMENTED, new Object[0]);
    }
}

