/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.custom;

import java.math.BigDecimal;
import java.util.Optional;
import org.javers.core.diff.changetype.ValueChange;
import org.javers.core.diff.custom.CustomPropertyComparator;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.property.Property;

public class CustomBigDecimalComparator
implements CustomPropertyComparator<BigDecimal, ValueChange> {
    private int significantDecimalPlaces;

    public CustomBigDecimalComparator(int significantDecimalPlaces) {
        this.significantDecimalPlaces = significantDecimalPlaces;
    }

    @Override
    public Optional<ValueChange> compare(BigDecimal left, BigDecimal right, GlobalId affectedId, Property property) {
        if (this.equals(left, right)) {
            return Optional.empty();
        }
        return Optional.of(new ValueChange(affectedId, property.getName(), left, right));
    }

    @Override
    public boolean equals(BigDecimal a, BigDecimal b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        BigDecimal aRounded = a.setScale(this.significantDecimalPlaces, 4);
        BigDecimal bRounded = b.setScale(this.significantDecimalPlaces, 4);
        return aRounded.equals(bRounded);
    }
}

