/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.javers.common.collections.EnumerableFunction;
import org.javers.common.collections.Maps;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.OwnerContext;
import org.javers.core.metamodel.type.KeyValueType;
import org.javers.core.metamodel.type.MapEnumerationOwnerContext;

public class MapType
extends KeyValueType {
    public MapType(Type baseJavaType) {
        super(baseJavaType, 2);
    }

    @Override
    public Object map(Object sourceEnumerable, EnumerableFunction mapFunction, OwnerContext owner) {
        return MapType.mapStatic(sourceEnumerable, mapFunction, owner);
    }

    public static Map mapStatic(Object sourceEnumerable, EnumerableFunction mapFunction, OwnerContext owner) {
        Validate.argumentsAreNotNull(mapFunction, owner);
        Map sourceMap = Maps.wrapNull(sourceEnumerable);
        HashMap targetMap = new HashMap(sourceMap.size());
        MapEnumerationOwnerContext enumeratorContext = new MapEnumerationOwnerContext(owner);
        MapType.mapEntrySet(sourceMap.entrySet(), mapFunction, enumeratorContext, (k, v) -> targetMap.put(k, v));
        return Collections.unmodifiableMap(targetMap);
    }

    @Override
    public Object map(Object sourceEnumerable, Function mapFunction) {
        Validate.argumentsAreNotNull(mapFunction);
        Map sourceMap = Maps.wrapNull(sourceEnumerable);
        HashMap targetMap = new HashMap(sourceMap.size());
        MapType.mapEntrySetFilterNulls(sourceMap.entrySet(), mapFunction, (k, v) -> targetMap.put(k, v));
        return targetMap;
    }

    @Override
    public boolean isEmpty(Object map) {
        return map == null || ((Map)map).isEmpty();
    }

    public static void mapEntrySet(Collection<Map.Entry<?, ?>> sourceEntries, EnumerableFunction mapFunction, MapEnumerationOwnerContext mapEnumerationContext, BiConsumer entryConsumer) {
        for (Map.Entry<?, ?> entry : sourceEntries) {
            mapEnumerationContext.switchToKey();
            Object mappedKey = mapFunction.apply(entry.getKey(), mapEnumerationContext);
            mapEnumerationContext.switchToValue(mappedKey);
            Object mappedValue = mapFunction.apply(entry.getValue(), mapEnumerationContext);
            entryConsumer.accept(mappedKey, mappedValue);
        }
    }

    public static void mapEntrySetFilterNulls(Collection<Map.Entry<?, ?>> sourceEntries, Function mapFunction, BiConsumer entryConsumer) {
        for (Map.Entry<?, ?> entry : sourceEntries) {
            Object mappedKey = mapFunction.apply(entry.getKey());
            if (mappedKey == null) continue;
            Object mappedValue = mapFunction.apply(entry.getValue());
            entryConsumer.accept(mappedKey, mappedValue);
        }
    }

    @Override
    public Object empty() {
        return Collections.emptyMap();
    }
}

