/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff;

import java.util.List;
import org.javers.common.validation.Validate;
import org.javers.core.diff.NodePair;
import org.javers.core.graph.ObjectNode;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.ManagedType;

public class RealNodePair
implements NodePair {
    private final ObjectNode left;
    private final ObjectNode right;

    public RealNodePair(ObjectNode left, ObjectNode right) {
        Validate.argumentsAreNotNull(left, right);
        Validate.argumentCheck(left.getGlobalId().equals(right.getGlobalId()), "left & right should refer to the same Cdo");
        this.left = left;
        this.right = right;
    }

    @Override
    public ManagedType getManagedType() {
        return this.right.getManagedType();
    }

    @Override
    public boolean isNullOnBothSides(Property property) {
        return this.left.getPropertyValue(property) == null && this.right.getPropertyValue(property) == null;
    }

    @Override
    public Object getLeftPropertyValue(Property property) {
        return this.left.getPropertyValue(property);
    }

    @Override
    public Object getRightPropertyValue(Property property) {
        return this.right.getPropertyValue(property);
    }

    @Override
    public GlobalId getRightGlobalId(Property property) {
        return this.right.getReference(property);
    }

    @Override
    public GlobalId getLeftGlobalId(Property property) {
        return this.left.getReference(property);
    }

    @Override
    public ObjectNode getRight() {
        return this.right;
    }

    @Override
    public List<JaversProperty> getProperties() {
        return this.getManagedType().getProperties();
    }

    @Override
    public GlobalId getGlobalId() {
        return this.left.getGlobalId();
    }
}

