/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.clazz.ClientsClassDefinition;
import org.javers.core.metamodel.type.DuckType;
import org.javers.core.metamodel.type.EntityType;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.TypeFactory;
import org.javers.core.metamodel.type.ValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TypeMapperState {
    private static final Logger logger = LoggerFactory.getLogger(TypeMapperState.class);
    public static final ValueType OBJECT_TYPE = new ValueType((Type)((Object)Object.class));
    private final Map<String, JaversType> mappedTypes = new ConcurrentHashMap<String, JaversType>();
    private final Map<DuckType, Class> mappedTypeNames = new ConcurrentHashMap<DuckType, Class>();
    private final TypeFactory typeFactory;

    TypeMapperState(TypeFactory typeFactory) {
        this.typeFactory = typeFactory;
    }

    Class getClassByTypeName(String typeName) {
        return this.getClassByDuckType(new DuckType(typeName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class getClassByDuckType(DuckType duckType) {
        Validate.argumentsAreNotNull(duckType);
        Class javaType = this.mappedTypeNames.get(duckType);
        if (javaType != null) {
            return javaType;
        }
        String string = duckType.getTypeName();
        synchronized (string) {
            Optional<? extends Class> classForName = this.parseClass(duckType.getTypeName());
            if (classForName.isPresent()) {
                this.mappedTypeNames.put(duckType, classForName.get());
                return classForName.get();
            }
        }
        if (!duckType.isBare()) {
            return this.getClassByDuckType(duckType.bareCopy());
        }
        throw new JaversException(JaversExceptionCode.TYPE_NAME_NOT_FOUND, duckType.getTypeName());
    }

    boolean contains(Type javaType) {
        return this.getFromMap(javaType) != null;
    }

    JaversType getJaversType(Type javaType) {
        Validate.argumentIsNotNull(javaType);
        if (javaType == Object.class) {
            return OBJECT_TYPE;
        }
        JaversType jType = this.getFromMap(javaType);
        if (jType != null) {
            return jType;
        }
        return this.computeIfAbsent(javaType, type -> this.infer((Type)type));
    }

    void putIfAbsent(Type javaType, JaversType jType) {
        this.computeIfAbsent(javaType, ignored -> jType);
    }

    void register(ClientsClassDefinition def) {
        Class<?> javaType = def.getBaseJavaClass();
        JaversType newType = this.typeFactory.create(def);
        this.addFullMapping(javaType, newType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JaversType computeIfAbsent(Type javaType, Function<Type, JaversType> computeFunction) {
        Type type = javaType;
        synchronized (type) {
            JaversType mappedType = this.getFromMap(javaType);
            if (mappedType != null) {
                return mappedType;
            }
            JaversType newType = computeFunction.apply(javaType);
            this.addFullMapping(javaType, newType);
            return newType;
        }
    }

    private void addFullMapping(Type javaType, JaversType newType) {
        Validate.argumentsAreNotNull(javaType, newType);
        this.putToMap(javaType, newType);
        if (newType instanceof ManagedType) {
            ManagedType managedType = (ManagedType)newType;
            this.mappedTypeNames.put(new DuckType(managedType.getName()), ReflectionUtil.extractClass(javaType));
            this.mappedTypeNames.put(new DuckType(managedType), ReflectionUtil.extractClass(javaType));
        }
        if (newType instanceof EntityType) {
            this.inferIdPropertyTypeForEntity((EntityType)newType);
        }
    }

    private void inferIdPropertyTypeForEntity(EntityType entityType) {
        Type idType = entityType.getIdPropertyGenericType();
        this.computeIfAbsent(idType, it -> {
            if (this.typeFactory.inferredAsEntity(idType)) {
                return this.typeFactory.infer((Type)it);
            }
            return this.typeFactory.inferIdPropertyTypeAsValue((Type)it);
        });
    }

    private JaversType infer(Type javaType) {
        Validate.argumentIsNotNull(javaType);
        return this.typeFactory.infer(javaType, this.findPrototype(javaType));
    }

    private Optional<JaversType> findPrototype(Type javaType) {
        Class javaClass = ReflectionUtil.extractClass(javaType);
        if (javaClass.isArray()) {
            return Optional.of(this.getJaversType((Type)((Object)Object[].class)));
        }
        JaversType selfClassType = this.getFromMap(javaClass);
        if (selfClassType != null && javaClass != javaType) {
            return Optional.of(selfClassType);
        }
        List<Type> hierarchy = ReflectionUtil.calculateHierarchyDistance(javaClass);
        for (Type parent : hierarchy) {
            JaversType jType = this.getFromMap(parent);
            if (jType == null || !jType.canBePrototype()) continue;
            logger.debug("proto for {} -> {}", (Object)javaType, (Object)jType);
            return Optional.of(jType);
        }
        return Optional.empty();
    }

    private Optional<? extends Class> parseClass(String qualifiedName) {
        try {
            return Optional.of(Class.forName(qualifiedName));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }

    private JaversType getFromMap(Type javaType) {
        return this.mappedTypes.get(javaType.toString());
    }

    private void putToMap(Type javaType, JaversType javersType) {
        this.mappedTypes.put(javaType.toString(), javersType);
    }
}

