/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.api;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.javers.common.validation.Validate;
import org.javers.core.commit.CommitId;
import org.javers.core.metamodel.object.SnapshotType;
import org.javers.repository.api.QueryParams;

public class QueryParamsBuilder {
    private int limit;
    private int skip;
    private LocalDateTime from;
    private LocalDateTime to;
    private CommitId toCommitId;
    private Set<CommitId> commitIds = new HashSet<CommitId>();
    private Long version;
    private String author;
    private boolean aggregate;
    private boolean newObjectChanges;
    private Map<String, String> commitProperties = new HashMap<String, String>();
    private String changedProperty;
    private SnapshotType snapshotType;
    private boolean loadCommitProps = true;

    private QueryParamsBuilder(int limit) {
        this.limit = limit;
        this.skip = 0;
    }

    public static QueryParamsBuilder withLimit(int limit) {
        QueryParamsBuilder.checkLimit(limit);
        return new QueryParamsBuilder(limit);
    }

    public QueryParamsBuilder withChildValueObjects(boolean aggregate) {
        this.aggregate = aggregate;
        return this;
    }

    public QueryParamsBuilder withCommitProps(boolean loadCommitProps) {
        this.loadCommitProps = loadCommitProps;
        return this;
    }

    public QueryParamsBuilder limit(int limit) {
        QueryParamsBuilder.checkLimit(limit);
        this.limit = limit;
        return this;
    }

    public QueryParamsBuilder skip(int skip) {
        Validate.argumentCheck(this.limit >= 0, "Skip is not a non-negative number.");
        this.skip = skip;
        return this;
    }

    public QueryParamsBuilder from(LocalDateTime from) {
        this.from = from;
        return this;
    }

    public QueryParamsBuilder to(LocalDateTime to) {
        this.to = to;
        return this;
    }

    public QueryParamsBuilder commitId(CommitId commitId) {
        this.commitIds.add(commitId);
        return this;
    }

    public QueryParamsBuilder toCommitId(CommitId toCommitId) {
        this.toCommitId = toCommitId;
        return this;
    }

    public QueryParamsBuilder commitIds(Collection<CommitId> commitIds) {
        this.commitIds.addAll(commitIds);
        return this;
    }

    public QueryParamsBuilder commitProperty(String name, String value) {
        this.commitProperties.put(name, value);
        return this;
    }

    public QueryParamsBuilder version(Long version) {
        this.version = version;
        return this;
    }

    public QueryParamsBuilder newObjectChanges(boolean newObjectChanges) {
        this.newObjectChanges = newObjectChanges;
        return this;
    }

    public QueryParamsBuilder withSnapshotType(SnapshotType snapshotType) {
        this.snapshotType = snapshotType;
        return this;
    }

    public QueryParamsBuilder changedProperty(String propertyName) {
        this.changedProperty = propertyName;
        return this;
    }

    public QueryParamsBuilder author(String author) {
        this.author = author;
        return this;
    }

    private static void checkLimit(int limit) {
        Validate.argumentCheck(limit > 0, "Limit is not a positive number.");
    }

    public QueryParams build() {
        return new QueryParams(this.limit, this.skip, this.from, this.to, this.commitIds, this.version, this.author, this.commitProperties, this.aggregate, this.newObjectChanges, this.changedProperty, this.toCommitId, this.snapshotType, this.loadCommitProps);
    }
}

