/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.object;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.javers.common.collections.Lists;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.type.EntityType;

public class ValueObjectId
extends GlobalId {
    private static final String SEGMENT_SEP = "/";
    private final GlobalId ownerId;
    private final String fragment;

    public ValueObjectId(String typeName, GlobalId ownerId, String fragment) {
        super(typeName);
        Validate.argumentsAreNotNull(ownerId, fragment);
        this.ownerId = ownerId;
        this.fragment = fragment;
    }

    public String getFragment() {
        return this.fragment;
    }

    public boolean hasOwnerOfType(EntityType entityType) {
        return this.ownerId.getTypeName().equals(entityType.getName());
    }

    public GlobalId getOwnerId() {
        return this.ownerId;
    }

    @Override
    public String value() {
        return this.getOwnerId().value() + "#" + this.fragment;
    }

    public Set<ValueObjectId> getParentValueObjectIds() {
        List<String> segments = this.segments();
        if (segments.size() == 1) {
            return Collections.emptySet();
        }
        return segments.stream().limit(segments.size() - 1).map(s -> new ValueObjectId(this.getTypeName(), this.ownerId, (String)s)).collect(Collectors.toSet());
    }

    private List<String> segments() {
        String[] segments = this.fragment.split(SEGMENT_SEP);
        List<String> joinedSegments = Lists.asList(segments[0]);
        if (segments.length > 1) {
            for (int i = 1; i < segments.length; ++i) {
                joinedSegments.add(joinedSegments.get(i - 1) + SEGMENT_SEP + segments[i]);
            }
        }
        return joinedSegments;
    }

    @Override
    public String toString() {
        return this.getOwnerId().toString() + "#" + this.fragment;
    }
}

