/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.changetype;

import java.util.Objects;
import java.util.Optional;
import org.javers.common.validation.Validate;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.diff.Change;
import org.javers.core.metamodel.object.GlobalId;

public abstract class PropertyChange
extends Change {
    private final String propertyName;

    protected PropertyChange(GlobalId affectedCdoId, String propertyName, Optional<CommitMetadata> commitMetadata) {
        super(affectedCdoId, Optional.empty(), commitMetadata);
        Validate.argumentIsNotNull(propertyName);
        this.propertyName = propertyName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    protected String fieldsToString() {
        return super.fieldsToString() + ", " + this.propertyName + "";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof PropertyChange) {
            PropertyChange that = (PropertyChange)o;
            return super.equals(that) && Objects.equals(this.propertyName, that.propertyName);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.propertyName);
    }
}

