/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.snapshot;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.javers.common.validation.Validate;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.metamodel.object.Cdo;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.LiveCdo;
import org.javers.core.snapshot.SnapshotFactory;

public class ChangedCdoSnapshotsFactory {
    private final SnapshotFactory snapshotFactory;

    ChangedCdoSnapshotsFactory(SnapshotFactory snapshotFactory) {
        this.snapshotFactory = snapshotFactory;
    }

    public List<CdoSnapshot> create(Set<LiveCdo> liveObjects, Set<CdoSnapshot> latestSnapshots, CommitMetadata commitMetadata) {
        Validate.argumentsAreNotNull(liveObjects, commitMetadata, latestSnapshots);
        ArrayList<CdoSnapshot> result = new ArrayList<CdoSnapshot>();
        for (LiveCdo currentCdo : liveObjects) {
            CdoSnapshot currentSnapshot;
            Optional<CdoSnapshot> previousSnapshot = latestSnapshots.stream().filter(currentCdo::equals).findFirst();
            if (!this.isCdoChanged(previousSnapshot, currentSnapshot = this.createSnapshot(latestSnapshots, commitMetadata, currentCdo, previousSnapshot))) continue;
            result.add(currentSnapshot);
        }
        return result;
    }

    private CdoSnapshot createSnapshot(Set<CdoSnapshot> previousCdos, CommitMetadata commitMetadata, LiveCdo liveCdo, Optional<CdoSnapshot> previousSnapshot) {
        return this.isNewlyCreated(liveCdo, previousCdos) ? this.createInitialSnapshot(commitMetadata, liveCdo) : this.createUpdateSnapshot(commitMetadata, liveCdo, previousSnapshot.get());
    }

    private boolean isNewlyCreated(Cdo cdo, Set<CdoSnapshot> previousCdos) {
        return !previousCdos.contains(cdo);
    }

    private CdoSnapshot createInitialSnapshot(CommitMetadata commitMetadata, LiveCdo liveCdo) {
        return this.snapshotFactory.createInitial(liveCdo, commitMetadata);
    }

    private CdoSnapshot createUpdateSnapshot(CommitMetadata commitMetadata, LiveCdo liveCdo, CdoSnapshot previousSnapshot) {
        return this.snapshotFactory.createUpdate(liveCdo, previousSnapshot, commitMetadata);
    }

    private boolean isCdoChanged(Optional<CdoSnapshot> previousSnapshot, CdoSnapshot currentSnapshot) {
        return !previousSnapshot.isPresent() || !previousSnapshot.get().stateEquals(currentSnapshot);
    }
}

