/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.snapshot;

import java.util.Objects;
import org.javers.common.collections.Defaults;
import org.javers.common.collections.EnumerableFunction;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.CdoSnapshotBuilder;
import org.javers.core.metamodel.object.CdoSnapshotState;
import org.javers.core.metamodel.object.CdoSnapshotStateBuilder;
import org.javers.core.metamodel.object.CdoWrapper;
import org.javers.core.metamodel.object.DehydrateContainerFunction;
import org.javers.core.metamodel.object.DehydrateMapFunction;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.GlobalIdFactory;
import org.javers.core.metamodel.object.OwnerContext;
import org.javers.core.metamodel.object.PropertyOwnerContext;
import org.javers.core.metamodel.object.SnapshotType;
import org.javers.core.metamodel.type.ContainerType;
import org.javers.core.metamodel.type.EnumerableType;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.KeyValueType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.MapContentType;
import org.javers.core.metamodel.type.TypeMapper;

public class SnapshotFactory {
    private final TypeMapper typeMapper;
    private final GlobalIdFactory globalIdFactory;

    public SnapshotFactory(TypeMapper typeMapper, GlobalIdFactory globalIdFactory) {
        this.typeMapper = typeMapper;
        this.globalIdFactory = globalIdFactory;
    }

    public CdoSnapshot createTerminal(GlobalId globalId, CdoSnapshot previous, CommitMetadata commitMetadata) {
        ManagedType managedType = this.typeMapper.getJaversManagedType(globalId);
        return CdoSnapshotBuilder.cdoSnapshot().withGlobalId(globalId).withManagedType(managedType).withCommitMetadata(commitMetadata).withType(SnapshotType.TERMINAL).withVersion(previous.getVersion() + 1L).build();
    }

    public CdoSnapshot createInitial(CdoWrapper cdoWrapper, CommitMetadata commitMetadata) {
        return this.initSnapshotBuilder(cdoWrapper, commitMetadata).withState(this.createSnapshotState(cdoWrapper)).withType(SnapshotType.INITIAL).markAllAsChanged().withVersion(1L).build();
    }

    public CdoSnapshot createUpdate(CdoWrapper cdoWrapper, CdoSnapshot previous, CommitMetadata commitMetadata) {
        return this.initSnapshotBuilder(cdoWrapper, commitMetadata).withState(this.createSnapshotState(cdoWrapper)).withType(SnapshotType.UPDATE).markChanged(previous).withVersion(previous.getVersion() + 1L).build();
    }

    public CdoSnapshotState createSnapshotState(CdoWrapper cdoWrapper) {
        CdoSnapshotStateBuilder stateBuilder = CdoSnapshotStateBuilder.cdoSnapshotState();
        for (JaversProperty property : cdoWrapper.getManagedType().getProperties()) {
            Object propertyVal = cdoWrapper.getPropertyValue(property.getName());
            if (Objects.equals(propertyVal, Defaults.defaultValue(property.getGenericType()))) continue;
            stateBuilder.withPropertyValue(property, this.dehydrateProperty(property, propertyVal, cdoWrapper.getGlobalId()));
        }
        return stateBuilder.build();
    }

    private Object extractAndDehydrateEnumerable(Object propertyVal, EnumerableType propertyType, OwnerContext owner) {
        EnumerableFunction dehydratorMapFunction;
        if (propertyType instanceof ContainerType) {
            JaversType itemType = this.typeMapper.getJaversType(((ContainerType)propertyType).getItemClass());
            dehydratorMapFunction = new DehydrateContainerFunction(itemType, this.globalIdFactory);
        } else if (propertyType instanceof KeyValueType) {
            MapContentType mapContentType = this.typeMapper.getMapContentType((KeyValueType)propertyType);
            dehydratorMapFunction = new DehydrateMapFunction(this.globalIdFactory, mapContentType);
        } else {
            throw new JaversException(JaversExceptionCode.NOT_IMPLEMENTED, new Object[0]);
        }
        return propertyType.map(propertyVal, dehydratorMapFunction, owner);
    }

    private CdoSnapshotBuilder initSnapshotBuilder(CdoWrapper cdoWrapper, CommitMetadata commitMetadata) {
        return CdoSnapshotBuilder.cdoSnapshot().withGlobalId(cdoWrapper.getGlobalId()).withCommitMetadata(commitMetadata).withManagedType(cdoWrapper.getManagedType());
    }

    private Object dehydrateProperty(JaversProperty property, Object propertyVal, GlobalId id) {
        PropertyOwnerContext owner = new PropertyOwnerContext(id, property.getName());
        if (property.getType() instanceof EnumerableType) {
            return this.extractAndDehydrateEnumerable(propertyVal, (EnumerableType)property.getType(), owner);
        }
        return this.globalIdFactory.dehydrate(propertyVal, (JaversType)property.getType(), owner);
    }
}

