/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.scanner;

import java.util.Collections;
import java.util.List;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.property.Property;

class PropertyScan {
    private final List<Property> properties;
    private final boolean hasId;

    PropertyScan(List<Property> properties) {
        Validate.argumentIsNotNull(properties);
        this.properties = properties;
        this.hasId = properties.stream().anyMatch(p -> p.looksLikeId());
    }

    public Property getFirst() {
        return this.properties.get(0);
    }

    public List<Property> getProperties() {
        return Collections.unmodifiableList(this.properties);
    }

    public boolean hasId() {
        return this.hasId;
    }
}

