/*
 * Decompiled with CFR 0.152.
 */
package org.javers.guava;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.core.diff.NodePair;
import org.javers.core.diff.appenders.CorePropertyChangeAppender;
import org.javers.core.diff.changetype.map.EntryAdded;
import org.javers.core.diff.changetype.map.EntryChange;
import org.javers.core.diff.changetype.map.EntryRemoved;
import org.javers.core.diff.changetype.map.MapChange;
import org.javers.core.metamodel.object.DehydrateMapFunction;
import org.javers.core.metamodel.object.GlobalIdFactory;
import org.javers.core.metamodel.object.OwnerContext;
import org.javers.core.metamodel.object.PropertyOwnerContext;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.KeyValueType;
import org.javers.core.metamodel.type.MapContentType;
import org.javers.core.metamodel.type.TypeMapper;
import org.javers.core.metamodel.type.ValueObjectType;
import org.javers.guava.MultimapType;
import org.javers.guava.Multimaps;

class MultimapChangeAppender
extends CorePropertyChangeAppender<MapChange> {
    private final TypeMapper typeMapper;
    private final GlobalIdFactory globalIdFactory;

    MultimapChangeAppender(TypeMapper typeMapper, GlobalIdFactory globalIdFactory) {
        this.typeMapper = typeMapper;
        this.globalIdFactory = globalIdFactory;
    }

    @Override
    public boolean supports(JaversType propertyType) {
        if (!(propertyType instanceof MultimapType)) {
            return false;
        }
        MapContentType mapContentType = this.typeMapper.getMapContentType((KeyValueType)propertyType);
        if (mapContentType.getKeyType() instanceof ValueObjectType) {
            throw new JaversException(JaversExceptionCode.VALUE_OBJECT_IS_NOT_SUPPORTED_AS_MAP_KEY, propertyType);
        }
        return true;
    }

    @Override
    public MapChange calculateChanges(NodePair pair, JaversProperty property) {
        PropertyOwnerContext owner;
        Multimap left = (Multimap)pair.getLeftPropertyValue(property);
        Multimap right = (Multimap)pair.getRightPropertyValue(property);
        MultimapType multimapType = (MultimapType)property.getType();
        List<EntryChange> entryChanges = this.calculateChanges(multimapType, left, right, owner = new PropertyOwnerContext(pair.getGlobalId(), property.getName()));
        if (!entryChanges.isEmpty()) {
            this.renderNotParametrizedWarningIfNeeded(multimapType.getKeyType(), "key", "Multimap", property);
            this.renderNotParametrizedWarningIfNeeded(multimapType.getValueType(), "value", "Multimap", property);
            return new MapChange(pair.getGlobalId(), property.getName(), entryChanges);
        }
        return null;
    }

    private List<EntryChange> calculateChanges(MultimapType multimapType, Multimap left, Multimap right, OwnerContext owner) {
        DehydrateMapFunction dehydrateFunction = this.getDehydrateMapFunction(multimapType);
        Multimap leftMultimap = multimapType.map(left, dehydrateFunction, owner);
        Multimap rightMultimap = multimapType.map(right, dehydrateFunction, owner);
        ArrayList<EntryChange> changes = new ArrayList<EntryChange>();
        for (Object commonKey : Multimaps.commonKeys(leftMultimap, rightMultimap)) {
            Collection leftValues = leftMultimap.get(commonKey);
            Collection rightValues = rightMultimap.get(commonKey);
            Collection difference = MultimapChangeAppender.difference(leftValues, rightValues);
            difference.addAll(MultimapChangeAppender.difference(rightValues, leftValues));
            if (difference.size() <= 0) continue;
            this.calculateValueChanges(changes, commonKey, leftValues, rightValues);
        }
        this.calculateKeyChanges(leftMultimap, rightMultimap, changes);
        return changes;
    }

    private static Collection difference(Collection first, Collection second) {
        if (first == null) {
            return Collections.EMPTY_LIST;
        }
        if (second == null) {
            return first;
        }
        ArrayList difference = new ArrayList(first);
        for (Object current : second) {
            difference.remove(current);
        }
        return difference;
    }

    private void calculateKeyChanges(Multimap leftMultimap, Multimap rightMultimap, List<EntryChange> changes) {
        for (Object addedKey : Multimaps.keysDifference(rightMultimap, leftMultimap)) {
            Collection difference = MultimapChangeAppender.difference(rightMultimap.get(addedKey), leftMultimap.get(addedKey));
            for (Object addedValue : difference) {
                changes.add(new EntryAdded(addedKey, addedValue));
            }
        }
        for (Object removedKey : Multimaps.keysDifference(leftMultimap, rightMultimap)) {
            for (Object removedValue : MultimapChangeAppender.difference(leftMultimap.get(removedKey), rightMultimap.get(removedKey))) {
                changes.add(new EntryRemoved(removedKey, removedValue));
            }
        }
    }

    private void calculateValueChanges(List<EntryChange> changes, Object commonKey, Collection leftVal, Collection rightVal) {
        Collection valuesAdded;
        if (Objects.equals(leftVal, rightVal)) {
            return;
        }
        Collection valuesRemoved = MultimapChangeAppender.difference(leftVal, rightVal);
        if (valuesRemoved.size() > 0) {
            for (Object addedValue : valuesRemoved) {
                changes.add(new EntryRemoved(commonKey, addedValue));
            }
        }
        if ((valuesAdded = MultimapChangeAppender.difference(rightVal, leftVal)).size() > 0) {
            for (Object addedValue : valuesAdded) {
                changes.add(new EntryAdded(commonKey, addedValue));
            }
        }
    }

    private DehydrateMapFunction getDehydrateMapFunction(MultimapType multimapType) {
        JaversType keyType = this.typeMapper.getJaversType(multimapType.getKeyType());
        JaversType valueType = this.typeMapper.getJaversType(multimapType.getValueType());
        MapContentType multiMapContentType = new MapContentType(keyType, valueType);
        return new DehydrateMapFunction(this.globalIdFactory, multiMapContentType);
    }
}

