/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.appenders;

import java.util.List;
import java.util.Set;
import org.javers.common.collections.Sets;
import org.javers.core.diff.NodePair;
import org.javers.core.diff.appenders.CorePropertyChangeAppender;
import org.javers.core.diff.appenders.SetChangeAppender;
import org.javers.core.diff.changetype.container.ContainerElementChange;
import org.javers.core.diff.changetype.container.ListChange;
import org.javers.core.metamodel.object.PropertyOwnerContext;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ListType;
import org.javers.core.metamodel.type.SetType;

public class SetListChangeAppender
extends CorePropertyChangeAppender<ListChange> {
    private final SetChangeAppender setChangeAppender;

    SetListChangeAppender(SetChangeAppender setChangeAppender) {
        this.setChangeAppender = setChangeAppender;
    }

    @Override
    public boolean supports(JaversType propertyType) {
        return propertyType instanceof ListType;
    }

    @Override
    public ListChange calculateChanges(NodePair pair, JaversProperty property) {
        Set leftList = Sets.asSet((List)pair.getLeftPropertyValue(property));
        Set rightList = Sets.asSet((List)pair.getRightPropertyValue(property));
        ListType listType = (ListType)property.getType();
        PropertyOwnerContext owner = new PropertyOwnerContext(pair.getGlobalId(), property.getName());
        SetType setType = new SetType(listType.getItemType());
        List<ContainerElementChange> entryChanges = this.setChangeAppender.calculateEntryChanges(setType, leftList, rightList, owner);
        if (!entryChanges.isEmpty()) {
            this.renderNotParametrizedWarningIfNeeded(setType.getItemType(), "item", "List", property);
            return new ListChange(pair.getGlobalId(), property.getName(), entryChanges);
        }
        return null;
    }
}

