/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.jql;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.string.ToStringBuilder;
import org.javers.common.validation.Validate;
import org.javers.core.commit.CommitId;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.GlobalIdFactory;
import org.javers.core.metamodel.object.InstanceId;
import org.javers.core.metamodel.object.ValueObjectId;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.TypeMapper;
import org.javers.repository.api.QueryParams;
import org.javers.repository.jql.AnyDomainObjectFilter;
import org.javers.repository.jql.ClassFilter;
import org.javers.repository.jql.Filter;
import org.javers.repository.jql.FilterDefinition;
import org.javers.repository.jql.IdFilter;
import org.javers.repository.jql.QueryType;
import org.javers.repository.jql.ShadowScope;
import org.javers.repository.jql.ShadowScopeDefinition;
import org.javers.repository.jql.VoOwnerFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JqlQuery {
    public static final String JQL_LOGGER_NAME = "org.javers.JQL";
    private static final Logger logger = LoggerFactory.getLogger((String)"org.javers.JQL");
    private QueryParams queryParams;
    private final FilterDefinition filterDefinition;
    private final ShadowScopeDefinition shadowScopeDef;
    private Filter filter;
    private Stats stats;

    JqlQuery(FilterDefinition filter, QueryParams queryParams, ShadowScopeDefinition shadowScope) {
        Validate.argumentsAreNotNull(filter);
        this.queryParams = queryParams;
        this.filterDefinition = filter;
        this.shadowScopeDef = shadowScope;
    }

    void validate() {
        if (this.isAggregate() && !this.isClassQuery() && !this.isInstanceIdQuery()) {
            throw new JaversException(JaversExceptionCode.MALFORMED_JQL, "aggregate filter can be enabled only for byClass and byInstanceId queries");
        }
        if (this.getShadowScope() != ShadowScope.DEEP_PLUS && this.getMaxGapsToFill() > 0) {
            throw new JaversException(JaversExceptionCode.MALFORMED_JQL, "maxGapsToFill can be used only in the DEEP_PLUS query scope");
        }
    }

    public String toString() {
        return "\nJqlQuery {\n  " + this.filter + "\n  " + this.queryParams + "\n  " + this.shadowScopeDef + "\n  " + this.stats + "\n}";
    }

    QueryParams getQueryParams() {
        return this.queryParams;
    }

    boolean hasFilter(Class<? extends Filter> ofType) {
        return this.getFilter(ofType).isPresent();
    }

    Set<ManagedType> getClassFilter() {
        return this.getFilter(ClassFilter.class).get().getManagedTypes();
    }

    GlobalId getIdFilter() {
        return this.getFilter(IdFilter.class).get().getGlobalId();
    }

    VoOwnerFilter getVoOwnerFilter() {
        return this.getFilter(VoOwnerFilter.class).get();
    }

    <T extends Filter> Optional<T> getFilter(Class<T> ofType) {
        Validate.conditionFulfilled(this.filter != null, "jqlQuery is not compiled");
        if (this.filter.getClass().equals(ofType)) {
            return Optional.of(this.filter);
        }
        return Optional.empty();
    }

    void compile(GlobalIdFactory globalIdFactory, TypeMapper typeMapper, QueryType queryType) {
        this.stats = new Stats();
        this.filter = this.filterDefinition.compile(globalIdFactory, typeMapper);
        if (queryType == QueryType.SHADOWS && (this.isInstanceIdQuery() || this.isClassQuery())) {
            this.queryParams = QueryParams.forShadowQuery(this.queryParams);
        }
        this.validate();
    }

    boolean matches(GlobalId globalId) {
        return this.filter.matches(globalId);
    }

    boolean isNewObjectChanges() {
        return this.queryParams.newObjectChanges();
    }

    boolean isAnyDomainObjectQuery() {
        return this.hasFilter(AnyDomainObjectFilter.class);
    }

    boolean isIdQuery() {
        return this.hasFilter(IdFilter.class);
    }

    boolean hasChangedPropertyFilter() {
        return this.queryParams.changedProperty().isPresent();
    }

    boolean isClassQuery() {
        return this.hasFilter(ClassFilter.class);
    }

    boolean isInstanceIdQuery() {
        Optional<IdFilter> idFilter = this.getFilter(IdFilter.class);
        return idFilter.isPresent() && idFilter.get().isInstanceIdFilter();
    }

    boolean isVoOwnerQuery() {
        return this.hasFilter(VoOwnerFilter.class);
    }

    public boolean isAggregate() {
        return this.queryParams.isAggregate();
    }

    public int getMaxGapsToFill() {
        return this.shadowScopeDef.getMaxGapsToFill();
    }

    public ShadowScope getShadowScope() {
        return this.shadowScopeDef.getScope();
    }

    public Stats stats() {
        return this.stats;
    }

    public static class Stats {
        private long startTimestamp = System.currentTimeMillis();
        private long endTimestamp;
        private int dbQueriesCount;
        private int allSnapshotsCount;
        private int shallowSnapshotsCount;
        private int deepPlusSnapshotsCount;
        private int commitDeepSnapshotsCount;
        private int childVOSnapshotsCount;
        private int deepPlusGapsFilled;
        private int deepPlusGapsLeft;

        void logQueryInChildValueObjectScope(GlobalId reference, CommitId context, int snapshotsLoaded) {
            this.validateChange();
            logger.debug("CHILD_VALUE_OBJECT query for '{}' at commitId {}, {} snapshot(s) loaded", new Object[]{reference.toString(), context.value(), snapshotsLoaded});
            ++this.dbQueriesCount;
            this.allSnapshotsCount += snapshotsLoaded;
            this.childVOSnapshotsCount += snapshotsLoaded;
        }

        void logMaxGapsToFillExceededInfo(GlobalId reference) {
            this.validateChange();
            ++this.deepPlusGapsLeft;
            logger.debug("warning: object '" + reference.toString() + "' is outside of the DEEP_PLUS+{} scope, references to this object will be nulled. Increase maxGapsToFill and fill all gaps in your object graph.", (Object)this.deepPlusGapsFilled);
        }

        void logQueryInDeepPlusScope(GlobalId reference, CommitId context, int snapshotsLoaded) {
            this.validateChange();
            ++this.dbQueriesCount;
            this.allSnapshotsCount += snapshotsLoaded;
            this.deepPlusSnapshotsCount += snapshotsLoaded;
            ++this.deepPlusGapsFilled;
            logger.debug("DEEP_PLUS query for '{}' at commitId {}, {} snapshot(s) loaded, gaps filled so far: {}", new Object[]{reference.toString(), context.value(), snapshotsLoaded, this.deepPlusGapsFilled});
        }

        void logShallowQuery(List<CdoSnapshot> snapshots) {
            this.validateChange();
            logger.debug("SHALLOW query: {} snapshots loaded (entities: {}, valueObjects: {})", new Object[]{snapshots.size(), snapshots.stream().filter(it -> it.getGlobalId() instanceof InstanceId).count(), snapshots.stream().filter(it -> it.getGlobalId() instanceof ValueObjectId).count()});
            ++this.dbQueriesCount;
            this.allSnapshotsCount += snapshots.size();
            this.shallowSnapshotsCount += snapshots.size();
        }

        void logQueryInCommitDeepScope(List<CdoSnapshot> snapshots) {
            this.validateChange();
            logger.debug("COMMIT_DEEP query: {} snapshots loaded", (Object)snapshots.size());
            ++this.dbQueriesCount;
            this.allSnapshotsCount += snapshots.size();
            this.commitDeepSnapshotsCount += snapshots.size();
        }

        void stop() {
            this.validateChange();
            this.endTimestamp = System.currentTimeMillis();
        }

        public String toString() {
            if (this.endTimestamp == 0L) {
                return ToStringBuilder.toString(this, "executed", "?");
            }
            return ToStringBuilder.toStringBlockStyle(this, "  ", "executed in millis", this.endTimestamp - this.startTimestamp, "DB queries", this.dbQueriesCount, "all snapshots", this.allSnapshotsCount, "SHALLOW snapshots", this.shallowSnapshotsCount, "COMMIT_DEEP snapshots", this.commitDeepSnapshotsCount, "CHILD_VALUE_OBJECT snapshots", this.childVOSnapshotsCount, "DEEP_PLUS snapshots", this.deepPlusSnapshotsCount, "gaps filled", this.deepPlusGapsFilled, "gaps left!", this.deepPlusGapsLeft);
        }

        public long getStartTimestamp() {
            return this.startTimestamp;
        }

        public long getEndTimestamp() {
            return this.endTimestamp;
        }

        public int getDbQueriesCount() {
            return this.dbQueriesCount;
        }

        public int getAllSnapshotsCount() {
            return this.allSnapshotsCount;
        }

        public int getShallowSnapshotsCount() {
            return this.shallowSnapshotsCount;
        }

        public int getDeepPlusSnapshotsCount() {
            return this.deepPlusSnapshotsCount;
        }

        public int getCommitDeepSnapshotsCount() {
            return this.commitDeepSnapshotsCount;
        }

        public int getChildVOSnapshotsCount() {
            return this.childVOSnapshotsCount;
        }

        public int getDeepPlusGapsFilled() {
            return this.deepPlusGapsFilled;
        }

        public int getDeepPlusGapsLeft() {
            return this.deepPlusGapsLeft;
        }

        private void validateChange() {
            if (this.endTimestamp > 0L) {
                throw new RuntimeException(new IllegalAccessException("executed query can't be changed"));
            }
        }
    }
}

