/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.json;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.io.Reader;
import java.lang.reflect.Type;
import org.javers.common.validation.Validate;
import org.javers.core.json.CdoSnapshotSerialized;
import org.javers.core.json.typeadapter.commit.CdoSnapshotAssembler;
import org.javers.core.metamodel.object.CdoSnapshot;

public class JsonConverter {
    private final Gson gson;
    private final CdoSnapshotAssembler cdoSnapshotAssembler;

    JsonConverter(Gson gson) {
        Validate.argumentsAreNotNull(gson);
        this.gson = gson;
        this.cdoSnapshotAssembler = new CdoSnapshotAssembler(this);
    }

    public String toJson(Object value) {
        return this.gson.toJson(value);
    }

    public JsonElement toJsonElement(Object value) {
        return this.gson.toJsonTree(value);
    }

    public <T> T fromJson(String json, Class<T> expectedType) {
        return (T)this.gson.fromJson(json, expectedType);
    }

    public Object fromJson(String json, Type expectedType) {
        return this.gson.fromJson(json, expectedType);
    }

    public JsonElement fromJsonToJsonElement(String json) {
        return (JsonElement)this.gson.fromJson(json, JsonElement.class);
    }

    public <T> T fromJson(JsonElement json, Class<T> expectedType) {
        return (T)this.gson.fromJson(json, expectedType);
    }

    public <T> T fromJson(Reader reader, Type expectedType) {
        return (T)this.gson.fromJson(reader, expectedType);
    }

    public CdoSnapshot fromSerializedSnapshot(CdoSnapshotSerialized cdoSnapshotSerialized) {
        return this.fromJson(this.cdoSnapshotAssembler.assemble(cdoSnapshotSerialized), CdoSnapshot.class);
    }
}

