/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.javers.common.collections.Lists;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.core.metamodel.annotation.DiffIgnore;
import org.javers.core.metamodel.clazz.ClientsClassDefinition;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.scanner.ClassScan;
import org.javers.core.metamodel.type.IgnoredType;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ManagedClass;
import org.javers.core.metamodel.type.TypeMapper;

class ManagedClassFactory {
    private final TypeMapper typeMapper;

    public ManagedClassFactory(TypeMapper typeMapper) {
        this.typeMapper = typeMapper;
    }

    ManagedClass create(Class<?> baseJavaClass, ClassScan scan) {
        List<JaversProperty> allProperties = this.convert(scan.getProperties());
        return new ManagedClass(baseJavaClass, allProperties, Lists.positiveFilter(allProperties, p -> p.looksLikeId()));
    }

    ManagedClass create(ClientsClassDefinition def, ClassScan scan) {
        List<JaversProperty> allProperties = this.convert(scan.getProperties());
        List<JaversProperty> filtered = this.filterIgnored(allProperties, def);
        filtered = this.filterIgnoredType(filtered, def.getBaseJavaClass());
        return new ManagedClass(def.getBaseJavaClass(), filtered, Lists.positiveFilter(allProperties, p -> p.looksLikeId()));
    }

    private List<JaversProperty> convert(List<Property> properties) {
        return Lists.transform(properties, p -> {
            if (this.typeMapper.contains(p.getGenericType())) {
                JaversType javersType = this.typeMapper.getJaversType(p.getGenericType());
                return new JaversProperty(() -> javersType, (Property)p);
            }
            return new JaversProperty(() -> this.typeMapper.getJaversType(p.getGenericType()), (Property)p);
        });
    }

    private List<JaversProperty> filterIgnoredType(List<JaversProperty> properties, Class<?> currentClass) {
        return Lists.negativeFilter(properties, property -> {
            if (property.getRawType() == currentClass) {
                return false;
            }
            if (this.typeMapper.contains(property.getRawType()) || this.typeMapper.contains(property.getGenericType())) {
                return this.typeMapper.getJaversType(property.getRawType()) instanceof IgnoredType;
            }
            return ReflectionUtil.isAnnotationPresentInHierarchy(property.getRawType(), DiffIgnore.class);
        });
    }

    private List<JaversProperty> filterIgnored(List<JaversProperty> properties, ClientsClassDefinition definition) {
        if (definition.getIgnoredProperties().isEmpty()) {
            return properties;
        }
        ArrayList<JaversProperty> filtered = new ArrayList<JaversProperty>(properties);
        for (String ignored : definition.getIgnoredProperties()) {
            this.filterOneProperty(filtered, ignored, definition.getBaseJavaClass());
        }
        return filtered;
    }

    private void filterOneProperty(List<JaversProperty> properties, String ignoredName, Class<?> clientsClass) {
        Iterator<JaversProperty> it = properties.iterator();
        while (it.hasNext()) {
            JaversProperty property = it.next();
            if (!property.getName().equals(ignoredName)) continue;
            it.remove();
            return;
        }
        throw new JaversException(JaversExceptionCode.PROPERTY_NOT_FOUND, ignoredName, clientsClass.getName());
    }
}

